/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.List;
import java.util.Optional;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.IMBORTreeRepository;
import nl.b3p.formendpoint.resource.IMBORTree;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IMBORTreeController
implements FormController<IMBORTree> {
    @Autowired
    IMBORTreeRepository repo;

    public Class getMaintainingClass() {
        return IMBORTree.class;
    }

    @GetMapping(value={"/imborboom/{objectGuid}"})
    public IMBORTree get(@PathVariable String objectGuid) {
        Optional maybe = this.repo.findByImborIdentificatie(objectGuid);
        IMBORTree IMBORTree2 = (IMBORTree)maybe.orElseThrow();
        return IMBORTree2;
    }

    public Page<IMBORTree> getAllPaged(@ParameterObject Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    public List<IMBORTree> getAll() {
        return this.repo.findAll();
    }

    public IMBORTree save(@RequestBody IMBORTree feature, String parentId) {
        return (IMBORTree)this.repo.save((Object)feature);
    }

    public IMBORTree update(@PathVariable String objectGuid, @RequestBody IMBORTree feature) {
        IMBORTree orig = (IMBORTree)this.repo.findByImborIdentificatie(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)feature, (Object)orig, (String[])new String[]{"planningen", "inspecties"});
        IMBORTree nieuw = (IMBORTree)this.repo.save((Object)orig);
        return nieuw;
    }

    public void delete(String objectGuid) {
        this.repo.deleteByImborIdentificatie(objectGuid);
    }

    @GetMapping(value={"/imborboom/{x}/{y}/{scale}"})
    public List<IMBORTree> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        return this.repo.findWithinPoint(p.buffer(scale));
    }
}

