package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.resource.Feature;
import nl.b3p.formendpoint.resource.Well;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

public interface FormController<E extends Feature> {
    default String getMaintainingClassString(){
        return getMaintainingClass().getSimpleName().toLowerCase();
    }
    Class getMaintainingClass();

    String attributefilter = null;

    E get(String objectGuid);

    List<E> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale);

    Page<E> getAllPaged(@ParameterObject Pageable pageable);

    List<E> getAll();

    E save(E feature, String parentId) throws Exception;

    E update(String objectGuid, E feature) throws Exception;

    void delete(String objectGuid);
}
