package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.FreeFallDuctRepository;
import nl.b3p.formendpoint.repository.MechanicalDuctRepository;
import nl.b3p.formendpoint.resource.FreeFallDuct;
import nl.b3p.formendpoint.resource.MechanicalDuct;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
public class FormFreeFallDuctController implements FormController<FreeFallDuct> {

    @Autowired
    FreeFallDuctRepository repo;

    @Override
    public Class getMaintainingClass() {
        return FreeFallDuct.class;
    }

    @GetMapping("/vrijevervalleiding/{objectGuid}")
    public FreeFallDuct get(@PathVariable String objectGuid) {
        return repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    @Override
    public Page<FreeFallDuct> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @Override
    public List<FreeFallDuct> getAll() {
        return repo.findAll();
    }

    @Override
    public FreeFallDuct save(@RequestBody FreeFallDuct feature, String parentId) {
        return repo.save(feature);
    }

    @Override
    public FreeFallDuct update(@PathVariable String objectGuid, @RequestBody FreeFallDuct feature) {
        FreeFallDuct orig=  repo.findByObjectGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(feature, orig, "planningen", "inspecties");
        FreeFallDuct nieuw = repo.save(orig);
        return nieuw;
    }

    @Override
    public void delete(String objectGuid) {
        repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value = "/vrijevervalleiding/{x}/{y}/{scale}")
    public List<FreeFallDuct> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }

}
