package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.PlanterRepository;
import nl.b3p.formendpoint.repository.PlanterRepository;
import nl.b3p.formendpoint.resource.Planter;
import nl.b3p.formendpoint.resource.Planter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
public class FormPlanterController implements FormController<Planter>{

    @Autowired
    PlanterRepository repo;

    Logger logger = LoggerFactory.getLogger(FormPlanterController.class);

    @GetMapping("/plantenbak/{objectGuid}")
    public Planter get(@PathVariable  String objectGuid) {
        Optional<Planter> ors = repo.findByObjectGuid(objectGuid);
        Planter rs = ors.orElseThrow( () -> new IllegalArgumentException("niet gevonden"));
        return rs;
    }

    @GetMapping(value = "/plantenbakken/unpaged")
    public List<Planter> getAll() {
        return repo.findAll();
    }

    @GetMapping(value = "/plantenbakken")
    public Page<Planter> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @GetMapping(value = "/plantenbakken/{x}/{y}/{scale}")
    public List<Planter> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }

    @PostMapping("/plantenbak")
    public Planter save(@RequestBody Planter wv, String parentId){
        return repo.save(wv);
    }

    @PutMapping("/plantenbak/{objectGuid}")
    public Planter update(@PathVariable  String objectGuid, @RequestBody Planter wv){
        Planter orig=  repo.findByObjectGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(wv, orig, "planningen");
        Planter nieuw = repo.save(orig);
        return nieuw;
    }

    @DeleteMapping("/plantenbak/{objectGuid}")
    public void delete(@PathVariable String objectGuid){
        repo.deleteByObjectGuid(objectGuid);
    }

    @Override
    public Class getMaintainingClass() {
        return Planter.class;
    }

}
