package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.RoadsectionRepository;
import nl.b3p.formendpoint.repository.RoadsectionplanningRepository;
import nl.b3p.formendpoint.resource.Roadsection;
import nl.b3p.formendpoint.resource.RoadsectionPlanning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("wegvakonderdeelplanning")
public class FormRoadsectionPartPlanningController implements FormController<RoadsectionPlanning>{

    @Autowired
    RoadsectionplanningRepository repo;

    @Autowired
    RoadsectionRepository wvRepo;

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping("/{objectGuid}")
    public RoadsectionPlanning get(@PathVariable String objectGuid) {
        return repo.findByDataGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));
    }

    @Override
    public List<RoadsectionPlanning> onPoint(double x, double y, double scale) {
        return new ArrayList<>();
    }

    @Override
    @GetMapping
    public Page<RoadsectionPlanning> getAllPaged(Pageable pageable) {
        return repo.findAll(pageable);
    }

    @GetMapping("/unpaged")
    public List<RoadsectionPlanning> getAll() {
        return repo.findAll();
    }

    @PostMapping
    public RoadsectionPlanning save(@RequestBody RoadsectionPlanning wv, String parentId){
        Roadsection parent = wvRepo.findByObjectGuid(parentId).orElseThrow( () -> new IllegalArgumentException("Parent niet gevonden"));;
        wv.setWegvakonderdeelId(parent.getObjectGuid());
        return repo.save(wv);
    }

    @PutMapping("/{objectGuid}")
    public RoadsectionPlanning update(@PathVariable  String objectGuid, @RequestBody RoadsectionPlanning wv){
        RoadsectionPlanning orig=  repo.findByDataGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(wv, orig);
        RoadsectionPlanning nieuw = repo.save(orig);
        return nieuw;
    }

    @DeleteMapping("/{objectGuid}")
    public void delete(@PathVariable String objectGuid){
        repo.deleteByDataGuid(objectGuid);
    }

    @Override
    public Class getMaintainingClass() {
        return RoadsectionPlanning.class;
    }
}
