package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.Grass;
import nl.b3p.formendpoint.resource.Tree;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface GrassRepository extends JpaRepository<Grass, Long> {
    Optional<Grass> findById(Long id);

    Optional<Grass> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<Grass> findWithinPoint(Geometry area);

}
