package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.Tree;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

public interface TreeRepository extends JpaRepository<Tree, Long> {
    Optional<Tree> findById(Long id);

    Optional<Tree> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<Tree> findWithinPoint(Geometry area);

}
