package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;

@Entity(name = "gb_haag_planning")
@Schema(
        name = "HaagPlanning",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class HedgePlanning implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Schema(name = "data_guid")
    private String dataGuid;

    private String maatregel_haag;
    private String maatregeltype;
    private Double jaarvanuitvoering;
    private Double hoeveelheid;
    private Double kosten;
    private Character gepland_uitgevoerd;
    private String planstatus;
    private String werkeenheid;
    private Double frequentie;
    private String haag_id;
    private String calc_plan_id;
    private String calc_plan_code;
    private String calc_plan_name;
    private Double belang;
    private String maatregelgroep;

    @Override
    public String getObjectGuid() {
        return dataGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.dataGuid = objectGuid;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDataGuid() {
        return dataGuid;
    }

    public void setDataGuid(String dataGuid) {
        this.dataGuid = dataGuid;
    }

    public String getMaatregel_haag() {
        return maatregel_haag;
    }

    public void setMaatregel_haag(String maatregel_haag) {
        this.maatregel_haag = maatregel_haag;
    }

    public String getMaatregeltype() {
        return maatregeltype;
    }

    public void setMaatregeltype(String maatregeltype) {
        this.maatregeltype = maatregeltype;
    }

    public Double getJaarvanuitvoering() {
        return jaarvanuitvoering;
    }

    public void setJaarvanuitvoering(Double jaarvanuitvoering) {
        this.jaarvanuitvoering = jaarvanuitvoering;
    }

    public Double getHoeveelheid() {
        return hoeveelheid;
    }

    public void setHoeveelheid(Double hoeveelheid) {
        this.hoeveelheid = hoeveelheid;
    }

    public Double getKosten() {
        return kosten;
    }

    public void setKosten(Double kosten) {
        this.kosten = kosten;
    }

    public Character getGepland_uitgevoerd() {
        return gepland_uitgevoerd;
    }

    public void setGepland_uitgevoerd(Character gepland_uitgevoerd) {
        this.gepland_uitgevoerd = gepland_uitgevoerd;
    }

    public String getPlanstatus() {
        return planstatus;
    }

    public void setPlanstatus(String planstatus) {
        this.planstatus = planstatus;
    }

    public String getWerkeenheid() {
        return werkeenheid;
    }

    public void setWerkeenheid(String werkeenheid) {
        this.werkeenheid = werkeenheid;
    }

    public Double getFrequentie() {
        return frequentie;
    }

    public void setFrequentie(Double frequentie) {
        this.frequentie = frequentie;
    }

    public String getHaag_id() {
        return haag_id;
    }

    public void setHaag_id(String haag_id) {
        this.haag_id = haag_id;
    }

    public String getCalc_plan_id() {
        return calc_plan_id;
    }

    public void setCalc_plan_id(String calc_plan_id) {
        this.calc_plan_id = calc_plan_id;
    }

    public String getCalc_plan_code() {
        return calc_plan_code;
    }

    public void setCalc_plan_code(String calc_plan_code) {
        this.calc_plan_code = calc_plan_code;
    }

    public String getCalc_plan_name() {
        return calc_plan_name;
    }

    public void setCalc_plan_name(String calc_plan_name) {
        this.calc_plan_name = calc_plan_name;
    }

    public Double getBelang() {
        return belang;
    }

    public void setBelang(Double belang) {
        this.belang = belang;
    }

    public String getMaatregelgroep() {
        return maatregelgroep;
    }

    public void setMaatregelgroep(String maatregelgroep) {
        this.maatregelgroep = maatregelgroep;
    }
}
