package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.locationtech.jts.geom.Point;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity(name = "gb_rioolput")
@Schema(
        name = "Rioolput",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Well implements Feature, Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Schema(implementation = org.geojson.Geometry.class)
    @Basic(optional = false)
    private Point geometrie;

    @Schema(name = "object_guid")
    private String objectGuid;


    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(referencedColumnName = "objectGuid", name = "rioolput_id")
    private List<WellPlanning> planningen = new ArrayList<>();

    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(referencedColumnName = "objectGuid", name = "rioolput_id")
    private List<WellInspection> inspecties = new ArrayList<>();

    @Override
    public List<Feature> getChildren() {
        List<Feature> childs = new ArrayList<>();
        if (planningen != null) {
            planningen.forEach(wellPlanning -> childs.add(wellPlanning));
        }
        if (inspecties != null) {
            inspecties.forEach(wellInspection -> childs.add(wellInspection));
        }
        return childs;
    }

    private String imgeo_id;
    private String bbv;
    private String domein;
    private String std_domein;
    private String beheercluster;
    private String std_beheercluster;
    private String structuurelement;
    private String std_structuurelement;
    private String beheerder_vakgeb;
    private String std_beheerder_vakgeb;
    private String bestek_nr;
    private String x62_cluster_aard;
    private String rayon;
    private String x62_std_rayon;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_eind_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_begin;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_eind;
    private String status;
    private String in_onderzoek;
    private Double relatieve_hoogteligging;
    private String bronhouder;
    private String type_put_plus;
    private Double afwijkendedieptelegging;
    private String bovengrondszichtbaar;
    private Double geonauwkeurigheidxy;
    private String type_leidingelement;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date eind_tijd;
    private String toelichting;
    private String afbeelding;
    private String beheerder;
    private String hoofdcategorie;
    private String x62_std_hoofdcategorie;
    private String categorie;
    private String x62_std_categorie;
    private String subcategorie;
    private String x62_std_subcategorie;
    private String rioolputtype;
    private String std_rioolputtype;
    private Double aanlegjaar;
    private Double aantal_pompen;
    private Double pompcapaciteit;
    private String x62_pompopstelling;
    private String grondsoort;
    private String std_grondsoort;
    private Double grondwaterstand;
    private String x62_lozingswerktype;
    private String x62_standaard_lozingswerktype;
    private String aansluitend_stelseltype;
    private String locatie;
    private String afspraak_waterschap;
    private String knoopnummer;
    private Double inschakelpeil;
    private Double uitschakelpeil;
    private Double maaiveldhoogte;
    private Double drempelhoogte_nap;
    private Double ontv_toelaatbaar_peilst;
    private Double ontv_waterpeil;
    private Double diameter;
    private Double lengte;
    private Double breedte;
    private Double waterpeil;
    private Double ontwerppeil_ontv_water;
    private Double gem_emissie_jaar_bzv;
    private Double gem_emissie_jaar;
    private Double x62_piek_emissie_2_jaar_bzv;
    private Double x62_piek_emissie_2_jaar;
    private Double x62_piek_emissie_5_jaar_bzv;
    private Double x62_piek_emissie_5_jaar;
    private Double x62_piek_emissie_10_jaar_bzv;
    private Double x62_piek_emissie_10_jaar;
    private Double drempel_breedte;
    private Double aantal_aansl_woonboten;
    private Double aantal_aansl_diversen;
    private Double aantal_aansl_bedrijven;
    private Double aantal_aansl_woningen;
    private Double aantal_aansl_horeca;
    private Double aantal_aansl_kolken;
    private String geleiding;
    private String onderhoudsfirma;
    private Double diameter_doorlaat;
    private Double hoogteligging_doorlaat;
    private Double hoogteligging_obl;
    private Double ontw_oppervlak;
    private Double ontw_doorl_grond;
    private Double ontw_hgt_grondwaterstand;
    private Double diameter_persaansluiting;
    private Double prognose_draaiuren;
    private Double hoogwaterpeil;
    private Double laagwaterpeil;
    private String telemetrie;
    private String funderingstype;
    private String std_funderingstype;
    private String materiaal_put;
    private String std_materiaal_put;
    private String putdekseltype;
    private String std_putdekseltype;
    private String int_putmateriaal;
    private String terugslagklep;
    private String kleptype;
    private String std_kleptype;
    private String ophanginrichting;
    private String geotextiel_inf_deel;
    private String materiaal_inf_deel;
    private String x62_infiltratieputtype;
    private String x62_std_infiltratieputtype;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date inspectiedatum;
    private Double dab_scheur;
    private Double dac_breuk_instorting;
    private Double dad_defect_metselwerk;
    private Double daf_schade_oppervlak;
    private Double dba_wortels;
    private Double dbd_binnendringen_grond;
    private Double dbf_infiltratie;
    private Double maaiveldhoogte_ontwerp;
    private Double maaiveldhoogte_actueel;
    private Double putdiepte;
    private Double diepte;
    private String bestek;
    private String tekening;
    private String putafmeting;
    private String putcode;
    private String hulpputcode;
    private String reinigingscyclus;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reinigingsjaar;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date volgend_reinigingsjaar;
    private String woonplaats;
    private String wijk;
    private String buurt;
    private String openbare_ruimte;
    private String rioolputhfdtype_gwsw;
    private String rioolputtype_gwsw;
    private String rioolputsubtype_gwsw;
    private Double aant_aansl_inwoner;
    private Double bergend_oppervlak;
    private Double breedte_toegang;
    private Double continue_lozing;
    private String x62_funderingstype_gwsw;
    private Double hoogte_put;
    private Double invoer;
    private Double x62_lengte_deksel;
    private Double lengte_putdeel;
    private Double lengte_toegang;
    private String leverancier_fabrikant;
    private String materiaal_gwsw;
    private Double opp_water_straat;
    private String vorm_gwsw;
    private String vorm_toegang;
    private Double porositeit;
    private Double niv_buitenwater;
    private String rl_voorziening_id;
    private String revisietekening;
    private Double bouwjaar_pomp;
    private String pomptype;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date datum_maaiveldhoogte;
    private String gemeente;
    private String verharding_wegdek;
    private String grondeigendom;
    private String mantoegankelijk;
    private Double aant_aansl_inw_recr;
    private String strategisch;
    private String sw_gebied_id;
    private String stelsel_id;
    private Double wanddikte;

    public Point getGeometrie() {
        return geometrie;
    }

    public void setGeometrie(Point geometrie) {
        this.geometrie = geometrie;
    }

    public String getObjectGuid() {
        return objectGuid;
    }

    public void setObjectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
    }

    public String getImgeo_id() {
        return imgeo_id;
    }

    public void setImgeo_id(String imgeo_id) {
        this.imgeo_id = imgeo_id;
    }

    public String getBbv() {
        return bbv;
    }

    public void setBbv(String bbv) {
        this.bbv = bbv;
    }

    public String getDomein() {
        return domein;
    }

    public void setDomein(String domein) {
        this.domein = domein;
    }

    public String getStd_domein() {
        return std_domein;
    }

    public void setStd_domein(String std_domein) {
        this.std_domein = std_domein;
    }

    public String getBeheercluster() {
        return beheercluster;
    }

    public void setBeheercluster(String beheercluster) {
        this.beheercluster = beheercluster;
    }

    public String getStd_beheercluster() {
        return std_beheercluster;
    }

    public void setStd_beheercluster(String std_beheercluster) {
        this.std_beheercluster = std_beheercluster;
    }

    public String getStructuurelement() {
        return structuurelement;
    }

    public void setStructuurelement(String structuurelement) {
        this.structuurelement = structuurelement;
    }

    public String getStd_structuurelement() {
        return std_structuurelement;
    }

    public void setStd_structuurelement(String std_structuurelement) {
        this.std_structuurelement = std_structuurelement;
    }

    public String getBeheerder_vakgeb() {
        return beheerder_vakgeb;
    }

    public void setBeheerder_vakgeb(String beheerder_vakgeb) {
        this.beheerder_vakgeb = beheerder_vakgeb;
    }

    public String getStd_beheerder_vakgeb() {
        return std_beheerder_vakgeb;
    }

    public void setStd_beheerder_vakgeb(String std_beheerder_vakgeb) {
        this.std_beheerder_vakgeb = std_beheerder_vakgeb;
    }

    public String getBestek_nr() {
        return bestek_nr;
    }

    public void setBestek_nr(String bestek_nr) {
        this.bestek_nr = bestek_nr;
    }

    public String getX62_cluster_aard() {
        return x62_cluster_aard;
    }

    public void setX62_cluster_aard(String x62_cluster_aard) {
        this.x62_cluster_aard = x62_cluster_aard;
    }

    public String getRayon() {
        return rayon;
    }

    public void setRayon(String rayon) {
        this.rayon = rayon;
    }

    public String getX62_std_rayon() {
        return x62_std_rayon;
    }

    public void setX62_std_rayon(String x62_std_rayon) {
        this.x62_std_rayon = x62_std_rayon;
    }

    public Date getObject_begin_tijd() {
        return object_begin_tijd;
    }

    public void setObject_begin_tijd(Date object_begin_tijd) {
        this.object_begin_tijd = object_begin_tijd;
    }

    public Date getObject_eind_tijd() {
        return object_eind_tijd;
    }

    public void setObject_eind_tijd(Date object_eind_tijd) {
        this.object_eind_tijd = object_eind_tijd;
    }

    public Date getReg_begin() {
        return reg_begin;
    }

    public void setReg_begin(Date reg_begin) {
        this.reg_begin = reg_begin;
    }

    public Date getReg_eind() {
        return reg_eind;
    }

    public void setReg_eind(Date reg_eind) {
        this.reg_eind = reg_eind;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIn_onderzoek() {
        return in_onderzoek;
    }

    public void setIn_onderzoek(String in_onderzoek) {
        this.in_onderzoek = in_onderzoek;
    }

    public Double getRelatieve_hoogteligging() {
        return relatieve_hoogteligging;
    }

    public void setRelatieve_hoogteligging(Double relatieve_hoogteligging) {
        this.relatieve_hoogteligging = relatieve_hoogteligging;
    }

    public String getBronhouder() {
        return bronhouder;
    }

    public void setBronhouder(String bronhouder) {
        this.bronhouder = bronhouder;
    }

    public String getType_put_plus() {
        return type_put_plus;
    }

    public void setType_put_plus(String type_put_plus) {
        this.type_put_plus = type_put_plus;
    }

    public Double getAfwijkendedieptelegging() {
        return afwijkendedieptelegging;
    }

    public void setAfwijkendedieptelegging(Double afwijkendedieptelegging) {
        this.afwijkendedieptelegging = afwijkendedieptelegging;
    }

    public String getBovengrondszichtbaar() {
        return bovengrondszichtbaar;
    }

    public void setBovengrondszichtbaar(String bovengrondszichtbaar) {
        this.bovengrondszichtbaar = bovengrondszichtbaar;
    }

    public Double getGeonauwkeurigheidxy() {
        return geonauwkeurigheidxy;
    }

    public void setGeonauwkeurigheidxy(Double geonauwkeurigheidxy) {
        this.geonauwkeurigheidxy = geonauwkeurigheidxy;
    }

    public String getType_leidingelement() {
        return type_leidingelement;
    }

    public void setType_leidingelement(String type_leidingelement) {
        this.type_leidingelement = type_leidingelement;
    }

    public Date getBegin_tijd() {
        return begin_tijd;
    }

    public void setBegin_tijd(Date begin_tijd) {
        this.begin_tijd = begin_tijd;
    }

    public Date getEind_tijd() {
        return eind_tijd;
    }

    public void setEind_tijd(Date eind_tijd) {
        this.eind_tijd = eind_tijd;
    }

    public String getToelichting() {
        return toelichting;
    }

    public void setToelichting(String toelichting) {
        this.toelichting = toelichting;
    }

    public String getAfbeelding() {
        return afbeelding;
    }

    public void setAfbeelding(String afbeelding) {
        this.afbeelding = afbeelding;
    }

    public String getBeheerder() {
        return beheerder;
    }

    public void setBeheerder(String beheerder) {
        this.beheerder = beheerder;
    }

    public String getHoofdcategorie() {
        return hoofdcategorie;
    }

    public void setHoofdcategorie(String hoofdcategorie) {
        this.hoofdcategorie = hoofdcategorie;
    }

    public String getX62_std_hoofdcategorie() {
        return x62_std_hoofdcategorie;
    }

    public void setX62_std_hoofdcategorie(String x62_std_hoofdcategorie) {
        this.x62_std_hoofdcategorie = x62_std_hoofdcategorie;
    }

    public String getCategorie() {
        return categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getX62_std_categorie() {
        return x62_std_categorie;
    }

    public void setX62_std_categorie(String x62_std_categorie) {
        this.x62_std_categorie = x62_std_categorie;
    }

    public String getSubcategorie() {
        return subcategorie;
    }

    public void setSubcategorie(String subcategorie) {
        this.subcategorie = subcategorie;
    }

    public String getX62_std_subcategorie() {
        return x62_std_subcategorie;
    }

    public void setX62_std_subcategorie(String x62_std_subcategorie) {
        this.x62_std_subcategorie = x62_std_subcategorie;
    }

    public String getRioolputtype() {
        return rioolputtype;
    }

    public void setRioolputtype(String rioolputtype) {
        this.rioolputtype = rioolputtype;
    }

    public String getStd_rioolputtype() {
        return std_rioolputtype;
    }

    public void setStd_rioolputtype(String std_rioolputtype) {
        this.std_rioolputtype = std_rioolputtype;
    }

    public Double getAanlegjaar() {
        return aanlegjaar;
    }

    public void setAanlegjaar(Double aanlegjaar) {
        this.aanlegjaar = aanlegjaar;
    }

    public Double getAantal_pompen() {
        return aantal_pompen;
    }

    public void setAantal_pompen(Double aantal_pompen) {
        this.aantal_pompen = aantal_pompen;
    }

    public Double getPompcapaciteit() {
        return pompcapaciteit;
    }

    public void setPompcapaciteit(Double pompcapaciteit) {
        this.pompcapaciteit = pompcapaciteit;
    }

    public String getX62_pompopstelling() {
        return x62_pompopstelling;
    }

    public void setX62_pompopstelling(String x62_pompopstelling) {
        this.x62_pompopstelling = x62_pompopstelling;
    }

    public String getGrondsoort() {
        return grondsoort;
    }

    public void setGrondsoort(String grondsoort) {
        this.grondsoort = grondsoort;
    }

    public String getStd_grondsoort() {
        return std_grondsoort;
    }

    public void setStd_grondsoort(String std_grondsoort) {
        this.std_grondsoort = std_grondsoort;
    }

    public Double getGrondwaterstand() {
        return grondwaterstand;
    }

    public void setGrondwaterstand(Double grondwaterstand) {
        this.grondwaterstand = grondwaterstand;
    }

    public String getX62_lozingswerktype() {
        return x62_lozingswerktype;
    }

    public void setX62_lozingswerktype(String x62_lozingswerktype) {
        this.x62_lozingswerktype = x62_lozingswerktype;
    }

    public String getX62_standaard_lozingswerktype() {
        return x62_standaard_lozingswerktype;
    }

    public void setX62_standaard_lozingswerktype(String x62_standaard_lozingswerktype) {
        this.x62_standaard_lozingswerktype = x62_standaard_lozingswerktype;
    }

    public String getAansluitend_stelseltype() {
        return aansluitend_stelseltype;
    }

    public void setAansluitend_stelseltype(String aansluitend_stelseltype) {
        this.aansluitend_stelseltype = aansluitend_stelseltype;
    }

    public String getLocatie() {
        return locatie;
    }

    public void setLocatie(String locatie) {
        this.locatie = locatie;
    }

    public String getAfspraak_waterschap() {
        return afspraak_waterschap;
    }

    public void setAfspraak_waterschap(String afspraak_waterschap) {
        this.afspraak_waterschap = afspraak_waterschap;
    }

    public String getKnoopnummer() {
        return knoopnummer;
    }

    public void setKnoopnummer(String knoopnummer) {
        this.knoopnummer = knoopnummer;
    }

    public Double getInschakelpeil() {
        return inschakelpeil;
    }

    public void setInschakelpeil(Double inschakelpeil) {
        this.inschakelpeil = inschakelpeil;
    }

    public Double getUitschakelpeil() {
        return uitschakelpeil;
    }

    public void setUitschakelpeil(Double uitschakelpeil) {
        this.uitschakelpeil = uitschakelpeil;
    }

    public Double getMaaiveldhoogte() {
        return maaiveldhoogte;
    }

    public void setMaaiveldhoogte(Double maaiveldhoogte) {
        this.maaiveldhoogte = maaiveldhoogte;
    }

    public Double getDrempelhoogte_nap() {
        return drempelhoogte_nap;
    }

    public void setDrempelhoogte_nap(Double drempelhoogte_nap) {
        this.drempelhoogte_nap = drempelhoogte_nap;
    }

    public Double getOntv_toelaatbaar_peilst() {
        return ontv_toelaatbaar_peilst;
    }

    public void setOntv_toelaatbaar_peilst(Double ontv_toelaatbaar_peilst) {
        this.ontv_toelaatbaar_peilst = ontv_toelaatbaar_peilst;
    }

    public Double getOntv_waterpeil() {
        return ontv_waterpeil;
    }

    public void setOntv_waterpeil(Double ontv_waterpeil) {
        this.ontv_waterpeil = ontv_waterpeil;
    }

    public Double getDiameter() {
        return diameter;
    }

    public void setDiameter(Double diameter) {
        this.diameter = diameter;
    }

    public Double getLengte() {
        return lengte;
    }

    public void setLengte(Double lengte) {
        this.lengte = lengte;
    }

    public Double getBreedte() {
        return breedte;
    }

    public void setBreedte(Double breedte) {
        this.breedte = breedte;
    }

    public Double getWaterpeil() {
        return waterpeil;
    }

    public void setWaterpeil(Double waterpeil) {
        this.waterpeil = waterpeil;
    }

    public Double getOntwerppeil_ontv_water() {
        return ontwerppeil_ontv_water;
    }

    public void setOntwerppeil_ontv_water(Double ontwerppeil_ontv_water) {
        this.ontwerppeil_ontv_water = ontwerppeil_ontv_water;
    }

    public Double getGem_emissie_jaar_bzv() {
        return gem_emissie_jaar_bzv;
    }

    public void setGem_emissie_jaar_bzv(Double gem_emissie_jaar_bzv) {
        this.gem_emissie_jaar_bzv = gem_emissie_jaar_bzv;
    }

    public Double getGem_emissie_jaar() {
        return gem_emissie_jaar;
    }

    public void setGem_emissie_jaar(Double gem_emissie_jaar) {
        this.gem_emissie_jaar = gem_emissie_jaar;
    }

    public Double getX62_piek_emissie_2_jaar_bzv() {
        return x62_piek_emissie_2_jaar_bzv;
    }

    public void setX62_piek_emissie_2_jaar_bzv(Double x62_piek_emissie_2_jaar_bzv) {
        this.x62_piek_emissie_2_jaar_bzv = x62_piek_emissie_2_jaar_bzv;
    }

    public Double getX62_piek_emissie_2_jaar() {
        return x62_piek_emissie_2_jaar;
    }

    public void setX62_piek_emissie_2_jaar(Double x62_piek_emissie_2_jaar) {
        this.x62_piek_emissie_2_jaar = x62_piek_emissie_2_jaar;
    }

    public Double getX62_piek_emissie_5_jaar_bzv() {
        return x62_piek_emissie_5_jaar_bzv;
    }

    public void setX62_piek_emissie_5_jaar_bzv(Double x62_piek_emissie_5_jaar_bzv) {
        this.x62_piek_emissie_5_jaar_bzv = x62_piek_emissie_5_jaar_bzv;
    }

    public Double getX62_piek_emissie_5_jaar() {
        return x62_piek_emissie_5_jaar;
    }

    public void setX62_piek_emissie_5_jaar(Double x62_piek_emissie_5_jaar) {
        this.x62_piek_emissie_5_jaar = x62_piek_emissie_5_jaar;
    }

    public Double getX62_piek_emissie_10_jaar_bzv() {
        return x62_piek_emissie_10_jaar_bzv;
    }

    public void setX62_piek_emissie_10_jaar_bzv(Double x62_piek_emissie_10_jaar_bzv) {
        this.x62_piek_emissie_10_jaar_bzv = x62_piek_emissie_10_jaar_bzv;
    }

    public Double getX62_piek_emissie_10_jaar() {
        return x62_piek_emissie_10_jaar;
    }

    public void setX62_piek_emissie_10_jaar(Double x62_piek_emissie_10_jaar) {
        this.x62_piek_emissie_10_jaar = x62_piek_emissie_10_jaar;
    }

    public Double getDrempel_breedte() {
        return drempel_breedte;
    }

    public void setDrempel_breedte(Double drempel_breedte) {
        this.drempel_breedte = drempel_breedte;
    }

    public Double getAantal_aansl_woonboten() {
        return aantal_aansl_woonboten;
    }

    public void setAantal_aansl_woonboten(Double aantal_aansl_woonboten) {
        this.aantal_aansl_woonboten = aantal_aansl_woonboten;
    }

    public Double getAantal_aansl_diversen() {
        return aantal_aansl_diversen;
    }

    public void setAantal_aansl_diversen(Double aantal_aansl_diversen) {
        this.aantal_aansl_diversen = aantal_aansl_diversen;
    }

    public Double getAantal_aansl_bedrijven() {
        return aantal_aansl_bedrijven;
    }

    public void setAantal_aansl_bedrijven(Double aantal_aansl_bedrijven) {
        this.aantal_aansl_bedrijven = aantal_aansl_bedrijven;
    }

    public Double getAantal_aansl_woningen() {
        return aantal_aansl_woningen;
    }

    public void setAantal_aansl_woningen(Double aantal_aansl_woningen) {
        this.aantal_aansl_woningen = aantal_aansl_woningen;
    }

    public Double getAantal_aansl_horeca() {
        return aantal_aansl_horeca;
    }

    public void setAantal_aansl_horeca(Double aantal_aansl_horeca) {
        this.aantal_aansl_horeca = aantal_aansl_horeca;
    }

    public Double getAantal_aansl_kolken() {
        return aantal_aansl_kolken;
    }

    public void setAantal_aansl_kolken(Double aantal_aansl_kolken) {
        this.aantal_aansl_kolken = aantal_aansl_kolken;
    }

    public String getGeleiding() {
        return geleiding;
    }

    public void setGeleiding(String geleiding) {
        this.geleiding = geleiding;
    }

    public String getOnderhoudsfirma() {
        return onderhoudsfirma;
    }

    public void setOnderhoudsfirma(String onderhoudsfirma) {
        this.onderhoudsfirma = onderhoudsfirma;
    }

    public Double getDiameter_doorlaat() {
        return diameter_doorlaat;
    }

    public void setDiameter_doorlaat(Double diameter_doorlaat) {
        this.diameter_doorlaat = diameter_doorlaat;
    }

    public Double getHoogteligging_doorlaat() {
        return hoogteligging_doorlaat;
    }

    public void setHoogteligging_doorlaat(Double hoogteligging_doorlaat) {
        this.hoogteligging_doorlaat = hoogteligging_doorlaat;
    }

    public Double getHoogteligging_obl() {
        return hoogteligging_obl;
    }

    public void setHoogteligging_obl(Double hoogteligging_obl) {
        this.hoogteligging_obl = hoogteligging_obl;
    }

    public Double getOntw_oppervlak() {
        return ontw_oppervlak;
    }

    public void setOntw_oppervlak(Double ontw_oppervlak) {
        this.ontw_oppervlak = ontw_oppervlak;
    }

    public Double getOntw_doorl_grond() {
        return ontw_doorl_grond;
    }

    public void setOntw_doorl_grond(Double ontw_doorl_grond) {
        this.ontw_doorl_grond = ontw_doorl_grond;
    }

    public Double getOntw_hgt_grondwaterstand() {
        return ontw_hgt_grondwaterstand;
    }

    public void setOntw_hgt_grondwaterstand(Double ontw_hgt_grondwaterstand) {
        this.ontw_hgt_grondwaterstand = ontw_hgt_grondwaterstand;
    }

    public Double getDiameter_persaansluiting() {
        return diameter_persaansluiting;
    }

    public void setDiameter_persaansluiting(Double diameter_persaansluiting) {
        this.diameter_persaansluiting = diameter_persaansluiting;
    }

    public Double getPrognose_draaiuren() {
        return prognose_draaiuren;
    }

    public void setPrognose_draaiuren(Double prognose_draaiuren) {
        this.prognose_draaiuren = prognose_draaiuren;
    }

    public Double getHoogwaterpeil() {
        return hoogwaterpeil;
    }

    public void setHoogwaterpeil(Double hoogwaterpeil) {
        this.hoogwaterpeil = hoogwaterpeil;
    }

    public Double getLaagwaterpeil() {
        return laagwaterpeil;
    }

    public void setLaagwaterpeil(Double laagwaterpeil) {
        this.laagwaterpeil = laagwaterpeil;
    }

    public String getTelemetrie() {
        return telemetrie;
    }

    public void setTelemetrie(String telemetrie) {
        this.telemetrie = telemetrie;
    }

    public String getFunderingstype() {
        return funderingstype;
    }

    public void setFunderingstype(String funderingstype) {
        this.funderingstype = funderingstype;
    }

    public String getStd_funderingstype() {
        return std_funderingstype;
    }

    public void setStd_funderingstype(String std_funderingstype) {
        this.std_funderingstype = std_funderingstype;
    }

    public String getMateriaal_put() {
        return materiaal_put;
    }

    public void setMateriaal_put(String materiaal_put) {
        this.materiaal_put = materiaal_put;
    }

    public String getStd_materiaal_put() {
        return std_materiaal_put;
    }

    public void setStd_materiaal_put(String std_materiaal_put) {
        this.std_materiaal_put = std_materiaal_put;
    }

    public String getPutdekseltype() {
        return putdekseltype;
    }

    public void setPutdekseltype(String putdekseltype) {
        this.putdekseltype = putdekseltype;
    }

    public String getStd_putdekseltype() {
        return std_putdekseltype;
    }

    public void setStd_putdekseltype(String std_putdekseltype) {
        this.std_putdekseltype = std_putdekseltype;
    }

    public String getInt_putmateriaal() {
        return int_putmateriaal;
    }

    public void setInt_putmateriaal(String int_putmateriaal) {
        this.int_putmateriaal = int_putmateriaal;
    }

    public String getTerugslagklep() {
        return terugslagklep;
    }

    public void setTerugslagklep(String terugslagklep) {
        this.terugslagklep = terugslagklep;
    }

    public String getKleptype() {
        return kleptype;
    }

    public void setKleptype(String kleptype) {
        this.kleptype = kleptype;
    }

    public String getStd_kleptype() {
        return std_kleptype;
    }

    public void setStd_kleptype(String std_kleptype) {
        this.std_kleptype = std_kleptype;
    }

    public String getOphanginrichting() {
        return ophanginrichting;
    }

    public void setOphanginrichting(String ophanginrichting) {
        this.ophanginrichting = ophanginrichting;
    }

    public String getGeotextiel_inf_deel() {
        return geotextiel_inf_deel;
    }

    public void setGeotextiel_inf_deel(String geotextiel_inf_deel) {
        this.geotextiel_inf_deel = geotextiel_inf_deel;
    }

    public String getMateriaal_inf_deel() {
        return materiaal_inf_deel;
    }

    public void setMateriaal_inf_deel(String materiaal_inf_deel) {
        this.materiaal_inf_deel = materiaal_inf_deel;
    }

    public String getX62_infiltratieputtype() {
        return x62_infiltratieputtype;
    }

    public void setX62_infiltratieputtype(String x62_infiltratieputtype) {
        this.x62_infiltratieputtype = x62_infiltratieputtype;
    }

    public String getX62_std_infiltratieputtype() {
        return x62_std_infiltratieputtype;
    }

    public void setX62_std_infiltratieputtype(String x62_std_infiltratieputtype) {
        this.x62_std_infiltratieputtype = x62_std_infiltratieputtype;
    }

    public Date getInspectiedatum() {
        return inspectiedatum;
    }

    public void setInspectiedatum(Date inspectiedatum) {
        this.inspectiedatum = inspectiedatum;
    }

    public Double getDab_scheur() {
        return dab_scheur;
    }

    public void setDab_scheur(Double dab_scheur) {
        this.dab_scheur = dab_scheur;
    }

    public Double getDac_breuk_instorting() {
        return dac_breuk_instorting;
    }

    public void setDac_breuk_instorting(Double dac_breuk_instorting) {
        this.dac_breuk_instorting = dac_breuk_instorting;
    }

    public Double getDad_defect_metselwerk() {
        return dad_defect_metselwerk;
    }

    public void setDad_defect_metselwerk(Double dad_defect_metselwerk) {
        this.dad_defect_metselwerk = dad_defect_metselwerk;
    }

    public Double getDaf_schade_oppervlak() {
        return daf_schade_oppervlak;
    }

    public void setDaf_schade_oppervlak(Double daf_schade_oppervlak) {
        this.daf_schade_oppervlak = daf_schade_oppervlak;
    }

    public Double getDba_wortels() {
        return dba_wortels;
    }

    public void setDba_wortels(Double dba_wortels) {
        this.dba_wortels = dba_wortels;
    }

    public Double getDbd_binnendringen_grond() {
        return dbd_binnendringen_grond;
    }

    public void setDbd_binnendringen_grond(Double dbd_binnendringen_grond) {
        this.dbd_binnendringen_grond = dbd_binnendringen_grond;
    }

    public Double getDbf_infiltratie() {
        return dbf_infiltratie;
    }

    public void setDbf_infiltratie(Double dbf_infiltratie) {
        this.dbf_infiltratie = dbf_infiltratie;
    }

    public Double getMaaiveldhoogte_ontwerp() {
        return maaiveldhoogte_ontwerp;
    }

    public void setMaaiveldhoogte_ontwerp(Double maaiveldhoogte_ontwerp) {
        this.maaiveldhoogte_ontwerp = maaiveldhoogte_ontwerp;
    }

    public Double getMaaiveldhoogte_actueel() {
        return maaiveldhoogte_actueel;
    }

    public void setMaaiveldhoogte_actueel(Double maaiveldhoogte_actueel) {
        this.maaiveldhoogte_actueel = maaiveldhoogte_actueel;
    }

    public Double getPutdiepte() {
        return putdiepte;
    }

    public void setPutdiepte(Double putdiepte) {
        this.putdiepte = putdiepte;
    }

    public Double getDiepte() {
        return diepte;
    }

    public void setDiepte(Double diepte) {
        this.diepte = diepte;
    }

    public String getBestek() {
        return bestek;
    }

    public void setBestek(String bestek) {
        this.bestek = bestek;
    }

    public String getTekening() {
        return tekening;
    }

    public void setTekening(String tekening) {
        this.tekening = tekening;
    }

    public String getPutafmeting() {
        return putafmeting;
    }

    public void setPutafmeting(String putafmeting) {
        this.putafmeting = putafmeting;
    }

    public String getPutcode() {
        return putcode;
    }

    public void setPutcode(String putcode) {
        this.putcode = putcode;
    }

    public String getHulpputcode() {
        return hulpputcode;
    }

    public void setHulpputcode(String hulpputcode) {
        this.hulpputcode = hulpputcode;
    }

    public String getReinigingscyclus() {
        return reinigingscyclus;
    }

    public void setReinigingscyclus(String reinigingscyclus) {
        this.reinigingscyclus = reinigingscyclus;
    }

    public Date getReinigingsjaar() {
        return reinigingsjaar;
    }

    public void setReinigingsjaar(Date reinigingsjaar) {
        this.reinigingsjaar = reinigingsjaar;
    }

    public Date getVolgend_reinigingsjaar() {
        return volgend_reinigingsjaar;
    }

    public void setVolgend_reinigingsjaar(Date volgend_reinigingsjaar) {
        this.volgend_reinigingsjaar = volgend_reinigingsjaar;
    }

    public String getWoonplaats() {
        return woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getWijk() {
        return wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getBuurt() {
        return buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOpenbare_ruimte() {
        return openbare_ruimte;
    }

    public void setOpenbare_ruimte(String openbare_ruimte) {
        this.openbare_ruimte = openbare_ruimte;
    }

    public String getRioolputhfdtype_gwsw() {
        return rioolputhfdtype_gwsw;
    }

    public void setRioolputhfdtype_gwsw(String rioolputhfdtype_gwsw) {
        this.rioolputhfdtype_gwsw = rioolputhfdtype_gwsw;
    }

    public String getRioolputtype_gwsw() {
        return rioolputtype_gwsw;
    }

    public void setRioolputtype_gwsw(String rioolputtype_gwsw) {
        this.rioolputtype_gwsw = rioolputtype_gwsw;
    }

    public String getRioolputsubtype_gwsw() {
        return rioolputsubtype_gwsw;
    }

    public void setRioolputsubtype_gwsw(String rioolputsubtype_gwsw) {
        this.rioolputsubtype_gwsw = rioolputsubtype_gwsw;
    }

    public Double getAant_aansl_inwoner() {
        return aant_aansl_inwoner;
    }

    public void setAant_aansl_inwoner(Double aant_aansl_inwoner) {
        this.aant_aansl_inwoner = aant_aansl_inwoner;
    }

    public Double getBergend_oppervlak() {
        return bergend_oppervlak;
    }

    public void setBergend_oppervlak(Double bergend_oppervlak) {
        this.bergend_oppervlak = bergend_oppervlak;
    }

    public Double getBreedte_toegang() {
        return breedte_toegang;
    }

    public void setBreedte_toegang(Double breedte_toegang) {
        this.breedte_toegang = breedte_toegang;
    }

    public Double getContinue_lozing() {
        return continue_lozing;
    }

    public void setContinue_lozing(Double continue_lozing) {
        this.continue_lozing = continue_lozing;
    }

    public String getX62_funderingstype_gwsw() {
        return x62_funderingstype_gwsw;
    }

    public void setX62_funderingstype_gwsw(String x62_funderingstype_gwsw) {
        this.x62_funderingstype_gwsw = x62_funderingstype_gwsw;
    }

    public Double getHoogte_put() {
        return hoogte_put;
    }

    public void setHoogte_put(Double hoogte_put) {
        this.hoogte_put = hoogte_put;
    }

    public Double getInvoer() {
        return invoer;
    }

    public void setInvoer(Double invoer) {
        this.invoer = invoer;
    }

    public Double getX62_lengte_deksel() {
        return x62_lengte_deksel;
    }

    public void setX62_lengte_deksel(Double x62_lengte_deksel) {
        this.x62_lengte_deksel = x62_lengte_deksel;
    }

    public Double getLengte_putdeel() {
        return lengte_putdeel;
    }

    public void setLengte_putdeel(Double lengte_putdeel) {
        this.lengte_putdeel = lengte_putdeel;
    }

    public Double getLengte_toegang() {
        return lengte_toegang;
    }

    public void setLengte_toegang(Double lengte_toegang) {
        this.lengte_toegang = lengte_toegang;
    }

    public String getLeverancier_fabrikant() {
        return leverancier_fabrikant;
    }

    public void setLeverancier_fabrikant(String leverancier_fabrikant) {
        this.leverancier_fabrikant = leverancier_fabrikant;
    }

    public String getMateriaal_gwsw() {
        return materiaal_gwsw;
    }

    public void setMateriaal_gwsw(String materiaal_gwsw) {
        this.materiaal_gwsw = materiaal_gwsw;
    }

    public Double getOpp_water_straat() {
        return opp_water_straat;
    }

    public void setOpp_water_straat(Double opp_water_straat) {
        this.opp_water_straat = opp_water_straat;
    }

    public String getVorm_gwsw() {
        return vorm_gwsw;
    }

    public void setVorm_gwsw(String vorm_gwsw) {
        this.vorm_gwsw = vorm_gwsw;
    }

    public String getVorm_toegang() {
        return vorm_toegang;
    }

    public void setVorm_toegang(String vorm_toegang) {
        this.vorm_toegang = vorm_toegang;
    }

    public Double getPorositeit() {
        return porositeit;
    }

    public void setPorositeit(Double porositeit) {
        this.porositeit = porositeit;
    }

    public Double getNiv_buitenwater() {
        return niv_buitenwater;
    }

    public void setNiv_buitenwater(Double niv_buitenwater) {
        this.niv_buitenwater = niv_buitenwater;
    }

    public String getRl_voorziening_id() {
        return rl_voorziening_id;
    }

    public void setRl_voorziening_id(String rl_voorziening_id) {
        this.rl_voorziening_id = rl_voorziening_id;
    }

    public String getRevisietekening() {
        return revisietekening;
    }

    public void setRevisietekening(String revisietekening) {
        this.revisietekening = revisietekening;
    }

    public Double getBouwjaar_pomp() {
        return bouwjaar_pomp;
    }

    public void setBouwjaar_pomp(Double bouwjaar_pomp) {
        this.bouwjaar_pomp = bouwjaar_pomp;
    }

    public String getPomptype() {
        return pomptype;
    }

    public void setPomptype(String pomptype) {
        this.pomptype = pomptype;
    }

    public Date getDatum_maaiveldhoogte() {
        return datum_maaiveldhoogte;
    }

    public void setDatum_maaiveldhoogte(Date datum_maaiveldhoogte) {
        this.datum_maaiveldhoogte = datum_maaiveldhoogte;
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public String getVerharding_wegdek() {
        return verharding_wegdek;
    }

    public void setVerharding_wegdek(String verharding_wegdek) {
        this.verharding_wegdek = verharding_wegdek;
    }

    public String getGrondeigendom() {
        return grondeigendom;
    }

    public void setGrondeigendom(String grondeigendom) {
        this.grondeigendom = grondeigendom;
    }

    public String getMantoegankelijk() {
        return mantoegankelijk;
    }

    public void setMantoegankelijk(String mantoegankelijk) {
        this.mantoegankelijk = mantoegankelijk;
    }

    public Double getAant_aansl_inw_recr() {
        return aant_aansl_inw_recr;
    }

    public void setAant_aansl_inw_recr(Double aant_aansl_inw_recr) {
        this.aant_aansl_inw_recr = aant_aansl_inw_recr;
    }

    public String getStrategisch() {
        return strategisch;
    }

    public void setStrategisch(String strategisch) {
        this.strategisch = strategisch;
    }

    public String getSw_gebied_id() {
        return sw_gebied_id;
    }

    public void setSw_gebied_id(String sw_gebied_id) {
        this.sw_gebied_id = sw_gebied_id;
    }

    public String getStelsel_id() {
        return stelsel_id;
    }

    public void setStelsel_id(String stelsel_id) {
        this.stelsel_id = stelsel_id;
    }

    public Double getWanddikte() {
        return wanddikte;
    }

    public void setWanddikte(Double wanddikte) {
        this.wanddikte = wanddikte;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public List<WellPlanning> getPlanningen() {
        return planningen;
    }

    public void setPlanningen(List<WellPlanning> planningen) {
        this.planningen = planningen;
    }

    public List<WellInspection> getInspecties() {
        return inspecties;
    }

    public void setInspecties(List<WellInspection> inspecties) {
        this.inspecties = inspecties;
    }
}
