/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import nl.b3p.formendpoint.resource.Feature;
import nl.b3p.formendpoint.resource.PlanterPlanning;
import org.geojson.Geometry;

@Entity(name="gb_plantenbak")
@Schema(name="Plantenbak", allOf={Feature.class})
@JsonIgnoreProperties(ignoreUnknown=true)
public class Planter
implements Feature,
Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Schema(name="object_guid")
    private String objectGuid;
    private String imgeo_id;
    private String bbv;
    private String domein;
    private String std_domein;
    private String beheercluster;
    private String std_beheercluster;
    private String structuurelement;
    private String std_structuurelement;
    private String beheerder_vakgeb;
    private String std_beheerder_vakgeb;
    private String bestek_nr;
    private String rayon;
    private String status;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date object_begin_tijd;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date object_eind_tijd;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date reg_begin;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date reg_eind;
    private Boolean in_onderzoek;
    private Integer relatieve_hoogteligging;
    private String bronhouder;
    private String type_bak_plus;
    @Schema(implementation=Geometry.class)
    @Basic(optional=false)
    private Polygon geometrie;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date begin_tijd;
    @JsonFormat(pattern="dd-MM-yyyy HH:mm:ss")
    private Date eind_tijd;
    private String toelichting;
    private String afbeelding;
    private String beheerder;
    private String hoofdcategorie;
    private String categorie;
    private String subcategorie;
    private Integer aanlegjaar;
    private Integer hoeveelheid;
    private String eenheid;
    private String gebruiksdruk;
    private String std_gebruiksdruk;
    private String baktype;
    private String std_baktype;
    private String ploegindeling;
    private String woonplaats;
    private String wijk;
    private String buurt;
    private String openbare_ruimte;
    private String gemeente;
    private String groenobject_id;
    private String x62_cluster_aard;
    private String x62_std_rayon;
    private String x62_std_hoofdcategorie;
    private String x62_std_categorie;
    private String x62_std_subcategorie;
    private String historie_guid;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(referencedColumnName="objectGuid", name="plantenbak_id")
    private List<PlanterPlanning> planningen = new ArrayList();

    public List<PlanterPlanning> getPlanningen() {
        return this.planningen;
    }

    public void setPlanningen(List<PlanterPlanning> planningen) {
        this.planningen = planningen;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getObjectGuid() {
        return this.objectGuid;
    }

    public void setObjectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
    }

    public String getImgeo_id() {
        return this.imgeo_id;
    }

    public void setImgeo_id(String imgeo_id) {
        this.imgeo_id = imgeo_id;
    }

    public String getBbv() {
        return this.bbv;
    }

    public void setBbv(String bbv) {
        this.bbv = bbv;
    }

    public String getDomein() {
        return this.domein;
    }

    public void setDomein(String domein) {
        this.domein = domein;
    }

    public String getStd_domein() {
        return this.std_domein;
    }

    public void setStd_domein(String std_domein) {
        this.std_domein = std_domein;
    }

    public String getBeheercluster() {
        return this.beheercluster;
    }

    public void setBeheercluster(String beheercluster) {
        this.beheercluster = beheercluster;
    }

    public String getStd_beheercluster() {
        return this.std_beheercluster;
    }

    public void setStd_beheercluster(String std_beheercluster) {
        this.std_beheercluster = std_beheercluster;
    }

    public String getStructuurelement() {
        return this.structuurelement;
    }

    public void setStructuurelement(String structuurelement) {
        this.structuurelement = structuurelement;
    }

    public String getStd_structuurelement() {
        return this.std_structuurelement;
    }

    public void setStd_structuurelement(String std_structuurelement) {
        this.std_structuurelement = std_structuurelement;
    }

    public String getBeheerder_vakgeb() {
        return this.beheerder_vakgeb;
    }

    public void setBeheerder_vakgeb(String beheerder_vakgeb) {
        this.beheerder_vakgeb = beheerder_vakgeb;
    }

    public String getStd_beheerder_vakgeb() {
        return this.std_beheerder_vakgeb;
    }

    public void setStd_beheerder_vakgeb(String std_beheerder_vakgeb) {
        this.std_beheerder_vakgeb = std_beheerder_vakgeb;
    }

    public String getBestek_nr() {
        return this.bestek_nr;
    }

    public void setBestek_nr(String bestek_nr) {
        this.bestek_nr = bestek_nr;
    }

    public String getRayon() {
        return this.rayon;
    }

    public void setRayon(String rayon) {
        this.rayon = rayon;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getObject_begin_tijd() {
        return this.object_begin_tijd;
    }

    public void setObject_begin_tijd(Date object_begin_tijd) {
        this.object_begin_tijd = object_begin_tijd;
    }

    public Date getObject_eind_tijd() {
        return this.object_eind_tijd;
    }

    public void setObject_eind_tijd(Date object_eind_tijd) {
        this.object_eind_tijd = object_eind_tijd;
    }

    public Date getReg_begin() {
        return this.reg_begin;
    }

    public void setReg_begin(Date reg_begin) {
        this.reg_begin = reg_begin;
    }

    public Date getReg_eind() {
        return this.reg_eind;
    }

    public void setReg_eind(Date reg_eind) {
        this.reg_eind = reg_eind;
    }

    public Boolean getIn_onderzoek() {
        return this.in_onderzoek;
    }

    public void setIn_onderzoek(Boolean in_onderzoek) {
        this.in_onderzoek = in_onderzoek;
    }

    public Integer getRelatieve_hoogteligging() {
        return this.relatieve_hoogteligging;
    }

    public void setRelatieve_hoogteligging(Integer relatieve_hoogteligging) {
        this.relatieve_hoogteligging = relatieve_hoogteligging;
    }

    public String getBronhouder() {
        return this.bronhouder;
    }

    public void setBronhouder(String bronhouder) {
        this.bronhouder = bronhouder;
    }

    public String getType_bak_plus() {
        return this.type_bak_plus;
    }

    public void setType_bak_plus(String type_bak_plus) {
        this.type_bak_plus = type_bak_plus;
    }

    public Polygon getGeometrie() {
        return this.geometrie;
    }

    public void setGeometrie(Polygon geometrie) {
        this.geometrie = geometrie;
    }

    public Date getBegin_tijd() {
        return this.begin_tijd;
    }

    public void setBegin_tijd(Date begin_tijd) {
        this.begin_tijd = begin_tijd;
    }

    public Date getEind_tijd() {
        return this.eind_tijd;
    }

    public void setEind_tijd(Date eind_tijd) {
        this.eind_tijd = eind_tijd;
    }

    public String getToelichting() {
        return this.toelichting;
    }

    public void setToelichting(String toelichting) {
        this.toelichting = toelichting;
    }

    public String getAfbeelding() {
        return this.afbeelding;
    }

    public void setAfbeelding(String afbeelding) {
        this.afbeelding = afbeelding;
    }

    public String getBeheerder() {
        return this.beheerder;
    }

    public void setBeheerder(String beheerder) {
        this.beheerder = beheerder;
    }

    public String getHoofdcategorie() {
        return this.hoofdcategorie;
    }

    public void setHoofdcategorie(String hoofdcategorie) {
        this.hoofdcategorie = hoofdcategorie;
    }

    public String getCategorie() {
        return this.categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getSubcategorie() {
        return this.subcategorie;
    }

    public void setSubcategorie(String subcategorie) {
        this.subcategorie = subcategorie;
    }

    public Integer getAanlegjaar() {
        return this.aanlegjaar;
    }

    public void setAanlegjaar(Integer aanlegjaar) {
        this.aanlegjaar = aanlegjaar;
    }

    public Integer getHoeveelheid() {
        return this.hoeveelheid;
    }

    public void setHoeveelheid(Integer hoeveelheid) {
        this.hoeveelheid = hoeveelheid;
    }

    public String getEenheid() {
        return this.eenheid;
    }

    public void setEenheid(String eenheid) {
        this.eenheid = eenheid;
    }

    public String getGebruiksdruk() {
        return this.gebruiksdruk;
    }

    public void setGebruiksdruk(String gebruiksdruk) {
        this.gebruiksdruk = gebruiksdruk;
    }

    public String getStd_gebruiksdruk() {
        return this.std_gebruiksdruk;
    }

    public void setStd_gebruiksdruk(String std_gebruiksdruk) {
        this.std_gebruiksdruk = std_gebruiksdruk;
    }

    public String getBaktype() {
        return this.baktype;
    }

    public void setBaktype(String baktype) {
        this.baktype = baktype;
    }

    public String getStd_baktype() {
        return this.std_baktype;
    }

    public void setStd_baktype(String std_baktype) {
        this.std_baktype = std_baktype;
    }

    public String getPloegindeling() {
        return this.ploegindeling;
    }

    public void setPloegindeling(String ploegindeling) {
        this.ploegindeling = ploegindeling;
    }

    public String getWoonplaats() {
        return this.woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getWijk() {
        return this.wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getBuurt() {
        return this.buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOpenbare_ruimte() {
        return this.openbare_ruimte;
    }

    public void setOpenbare_ruimte(String openbare_ruimte) {
        this.openbare_ruimte = openbare_ruimte;
    }

    public String getGemeente() {
        return this.gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public String getGroenobject_id() {
        return this.groenobject_id;
    }

    public void setGroenobject_id(String groenobject_id) {
        this.groenobject_id = groenobject_id;
    }

    public String getX62_cluster_aard() {
        return this.x62_cluster_aard;
    }

    public void setX62_cluster_aard(String x62_cluster_aard) {
        this.x62_cluster_aard = x62_cluster_aard;
    }

    public String getX62_std_rayon() {
        return this.x62_std_rayon;
    }

    public void setX62_std_rayon(String x62_std_rayon) {
        this.x62_std_rayon = x62_std_rayon;
    }

    public String getX62_std_hoofdcategorie() {
        return this.x62_std_hoofdcategorie;
    }

    public void setX62_std_hoofdcategorie(String x62_std_hoofdcategorie) {
        this.x62_std_hoofdcategorie = x62_std_hoofdcategorie;
    }

    public String getX62_std_categorie() {
        return this.x62_std_categorie;
    }

    public void setX62_std_categorie(String x62_std_categorie) {
        this.x62_std_categorie = x62_std_categorie;
    }

    public String getX62_std_subcategorie() {
        return this.x62_std_subcategorie;
    }

    public void setX62_std_subcategorie(String x62_std_subcategorie) {
        this.x62_std_subcategorie = x62_std_subcategorie;
    }

    public String getHistorie_guid() {
        return this.historie_guid;
    }

    public void setHistorie_guid(String historie_guid) {
        this.historie_guid = historie_guid;
    }

    public List<Feature> getChildren() {
        ArrayList<Feature> children = new ArrayList<Feature>();
        if (this.planningen != null) {
            this.planningen.forEach(planterPlanning -> children.add((Feature)planterPlanning));
        }
        return children;
    }
}

