package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.Well;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

public interface WellRepository extends JpaRepository<Well, Long> {
    Optional<Well> findById(Long id);

    Optional<Well> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<Well> findWithinPoint(Geometry area);

}
