package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;

@Entity(name = "gb_vrijvervalleiding_planning")
@Schema(
        name = "VrijvLeidingPlanning",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class FreeFallDuctPlanning implements Feature, Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @Schema(name="data_guid")
    private String dataGuid;
    private String maatregel_vvrrleid;
    private String maatregeltype;
    private Double jaarvanuitvoering;
    private Double hoeveelheid;
    private Double kosten;
    private Character gepland_uitgevoerd;
    private String planstatus;
    private Double frequentie;
    private String memo;
    private String vrijv_leiding_id;
    private String maatregelcode;
    private String hoofdmaatregel;
    private String calc_plan_id;
    private String calc_plan_code;
    private String calc_plan_name;
    private Double eenheidsprijs;
    private Double kostenfactor;
    private String dekkingscode;
    private String toeslagen;
    private Double vaste_kosten;
    private Double belang;
    private String maatregelgroep;
    private Double afstand_begin;
    private Double afstand_eind;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDataGuid() {
        return dataGuid;
    }

    public void setDataGuid(String dataGuid) {
        this.dataGuid = dataGuid;
    }

    public String getMaatregel_vvrrleid() {
        return maatregel_vvrrleid;
    }

    public void setMaatregel_vvrrleid(String maatregel_vvrrleid) {
        this.maatregel_vvrrleid = maatregel_vvrrleid;
    }

    public String getMaatregeltype() {
        return maatregeltype;
    }

    public void setMaatregeltype(String maatregeltype) {
        this.maatregeltype = maatregeltype;
    }

    public Double getJaarvanuitvoering() {
        return jaarvanuitvoering;
    }

    public void setJaarvanuitvoering(Double jaarvanuitvoering) {
        this.jaarvanuitvoering = jaarvanuitvoering;
    }

    public Double getHoeveelheid() {
        return hoeveelheid;
    }

    public void setHoeveelheid(Double hoeveelheid) {
        this.hoeveelheid = hoeveelheid;
    }

    public Double getKosten() {
        return kosten;
    }

    public void setKosten(Double kosten) {
        this.kosten = kosten;
    }

    public Character getGepland_uitgevoerd() {
        return gepland_uitgevoerd;
    }

    public void setGepland_uitgevoerd(Character gepland_uitgevoerd) {
        this.gepland_uitgevoerd = gepland_uitgevoerd;
    }

    public String getPlanstatus() {
        return planstatus;
    }

    public void setPlanstatus(String planstatus) {
        this.planstatus = planstatus;
    }

    public Double getFrequentie() {
        return frequentie;
    }

    public void setFrequentie(Double frequentie) {
        this.frequentie = frequentie;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getVrijv_leiding_id() {
        return vrijv_leiding_id;
    }

    public void setVrijv_leiding_id(String vrijv_leiding_id) {
        this.vrijv_leiding_id = vrijv_leiding_id;
    }

    public String getMaatregelcode() {
        return maatregelcode;
    }

    public void setMaatregelcode(String maatregelcode) {
        this.maatregelcode = maatregelcode;
    }

    public String getHoofdmaatregel() {
        return hoofdmaatregel;
    }

    public void setHoofdmaatregel(String hoofdmaatregel) {
        this.hoofdmaatregel = hoofdmaatregel;
    }

    public String getCalc_plan_id() {
        return calc_plan_id;
    }

    public void setCalc_plan_id(String calc_plan_id) {
        this.calc_plan_id = calc_plan_id;
    }

    public String getCalc_plan_code() {
        return calc_plan_code;
    }

    public void setCalc_plan_code(String calc_plan_code) {
        this.calc_plan_code = calc_plan_code;
    }

    public String getCalc_plan_name() {
        return calc_plan_name;
    }

    public void setCalc_plan_name(String calc_plan_name) {
        this.calc_plan_name = calc_plan_name;
    }

    public Double getEenheidsprijs() {
        return eenheidsprijs;
    }

    public void setEenheidsprijs(Double eenheidsprijs) {
        this.eenheidsprijs = eenheidsprijs;
    }

    public Double getKostenfactor() {
        return kostenfactor;
    }

    public void setKostenfactor(Double kostenfactor) {
        this.kostenfactor = kostenfactor;
    }

    public String getDekkingscode() {
        return dekkingscode;
    }

    public void setDekkingscode(String dekkingscode) {
        this.dekkingscode = dekkingscode;
    }

    public String getToeslagen() {
        return toeslagen;
    }

    public void setToeslagen(String toeslagen) {
        this.toeslagen = toeslagen;
    }

    public Double getVaste_kosten() {
        return vaste_kosten;
    }

    public void setVaste_kosten(Double vaste_kosten) {
        this.vaste_kosten = vaste_kosten;
    }

    public Double getBelang() {
        return belang;
    }

    public void setBelang(Double belang) {
        this.belang = belang;
    }

    public String getMaatregelgroep() {
        return maatregelgroep;
    }

    public void setMaatregelgroep(String maatregelgroep) {
        this.maatregelgroep = maatregelgroep;
    }

    public Double getAfstand_begin() {
        return afstand_begin;
    }

    public void setAfstand_begin(Double afstand_begin) {
        this.afstand_begin = afstand_begin;
    }

    public Double getAfstand_eind() {
        return afstand_eind;
    }

    public void setAfstand_eind(Double afstand_eind) {
        this.afstand_eind = afstand_eind;
    }

    @Override
    public String getObjectGuid() {
        return dataGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.dataGuid = objectGuid;
    }
}
