package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.ArtificialWorkPartRepository;
import nl.b3p.formendpoint.resource.ArtificialWorkPart;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
public class FormArtificialWorkPartController implements FormController<ArtificialWorkPart>{

    @Autowired
    ArtificialWorkPartRepository repo;

    @Override
    public Class getMaintainingClass() {
        return ArtificialWorkPart.class;
    }

    @GetMapping("/kunstwerkdeel/{objectGuid}")
    public ArtificialWorkPart get(@PathVariable String objectGuid) {
        return repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    @Override
    public Page<ArtificialWorkPart> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @Override
    public List<ArtificialWorkPart> getAll() {
        return repo.findAll();
    }

    @Override
    public ArtificialWorkPart save(@RequestBody ArtificialWorkPart feature, String parentId) {
        return repo.save(feature);
    }

    @Override
    public ArtificialWorkPart update(@PathVariable String objectGuid, @RequestBody ArtificialWorkPart feature) {
        ArtificialWorkPart orig=  repo.findByObjectGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(feature, orig, "planningen", "inspecties");
        ArtificialWorkPart nieuw = repo.save(orig);
        return nieuw;
    }

    @Override
    public void delete(String objectGuid) {
        repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value = "/kunstwerkdeel/{x}/{y}/{scale}")
    public List<ArtificialWorkPart> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }

}
