package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.Hedge;
import nl.b3p.formendpoint.resource.Tree;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface HedgeRepository extends JpaRepository<Hedge, Long> {
    Optional<Hedge> findById(Long id);

    Optional<Hedge> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<Hedge> findWithinPoint(Geometry area);

}
