package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.hibernate.annotations.ColumnTransformer;
import org.locationtech.jts.geom.Geometry;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity(name = "gb_Boom")
@Schema(
        name = "Boom",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Tree implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Schema(implementation = org.geojson.Geometry.class)
    @Basic(optional = false)
    @ColumnTransformer(
            read = "st_curvetoline(geometrie)"
    )
    private Geometry geometrie;

    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(referencedColumnName = "objectGuid", name = "boom_id")
    private List<TreePlanning> planningen = new ArrayList<>();

    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(referencedColumnName = "objectGuid", name = "boom_id")
    private List<TreeInspection> inspecties = new ArrayList<>();

    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(referencedColumnName = "objectGuid", name = "boom_id")
    private List<TreeSupport> onderhouden = new ArrayList<>();

    @Schema(name = "object_guid")
    private String objectGuid;

    private String imgeo_id;
    private String bbv;
    private String domein;
    private String std_domein;
    private String beheercluster;
    private String std_beheercluster;
    private String structuurelement;
    private String std_structuurelement;
    private String beheerder_vakgeb;
    private String std_beheerder_vakgeb;
    private String bestek_nr;
    private String x62_cluster_aard;
    private String rayon;
    private String x62_std_rayon;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_eind_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_begin;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_eind;
    private String status;
    private String in_onderzoek;
    private Double relatieve_hoogteligging;
    private String bronhouder;
    private String type_vegetatieobj_plus;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date eind_tijd;
    private String toelichting;
    private String afbeelding;
    private String beheerder;
    private String hoofdcategorie;
    private String x62_std_hoofdcategorie;
    private String categorie;
    private String x62_std_categorie;
    private String subcategorie;
    private String x62_std_subcategorie;
    private String boomtype;
    private String std_boomtype;
    private String standplaats;
    private String std_standplaats;
    private String ontwikkelingsstadium;
    private String std_ontwikkelingsstadium;
    private String nedboomsoort;
    private String latboomsoort;
    private String opkroonhoogte;
    private String std_opkroonhoogte;
    private String diameter;
    private String std_diameter;
    private String boomhoogte;
    private String std_boomhoogte;
    private Double aanlegjaar;
    private String vergunningsplicht;
    private String boomrooster;
    private String boombeschermer;
    private String grasspiegel;
    private String gietijzeren_boomkrans;
    private String ploegindeling;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date inspectiedatum;
    private String gak;
    private String dhk;
    private String utk;
    private String bvk;
    private String pzk;
    private String ink;
    private String rzk;
    private String hgk;
    private String memo_kroon;
    private String gas;
    private String ins;
    private String rzs;
    private String his;
    private String srs;
    private String mbs;
    private String scs;
    private String aes;
    private String memo_stam;
    private String gaw;
    private String rzw;
    private String bww;
    private String gsw;
    private String ovw;
    private String memo_wortels;
    private String noa;
    private String bva;
    private String bsa;
    private String bra;
    private String kva;
    private String memo_advies;
    private String memo_vta;
    private String afbeelding_vta;
    private String risicoklasse;
    private String boomconditie;
    private String urgentie_vta;
    private String inspectiefrequentie;
    private String inspecteur_vta;
    private String woonplaats;
    private String wijk;
    private String buurt;
    private String openbare_ruimte;
    private String groenobject_id;
    private String bijzondere_boom;
    private String eigenaar;
    private String omgevingsrisicoklasse;
    private String boomveiligheidsklasse;
    private String gemeente;

    @Override
    public String getObjectGuid() {
        return objectGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
    }

    public String getImgeo_id() {
        return imgeo_id;
    }

    public void setImgeo_id(String imgeo_id) {
        this.imgeo_id = imgeo_id;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBbv() {
        return bbv;
    }

    public void setBbv(String bbv) {
        this.bbv = bbv;
    }

    public String getDomein() {
        return domein;
    }

    public void setDomein(String domein) {
        this.domein = domein;
    }

    public String getStd_domein() {
        return std_domein;
    }

    public void setStd_domein(String std_domein) {
        this.std_domein = std_domein;
    }

    public String getBeheercluster() {
        return beheercluster;
    }

    public void setBeheercluster(String beheercluster) {
        this.beheercluster = beheercluster;
    }

    public String getStd_beheercluster() {
        return std_beheercluster;
    }

    public void setStd_beheercluster(String std_beheercluster) {
        this.std_beheercluster = std_beheercluster;
    }

    public String getStructuurelement() {
        return structuurelement;
    }

    public void setStructuurelement(String structuurelement) {
        this.structuurelement = structuurelement;
    }

    public String getStd_structuurelement() {
        return std_structuurelement;
    }

    public void setStd_structuurelement(String std_structuurelement) {
        this.std_structuurelement = std_structuurelement;
    }

    public String getBeheerder_vakgeb() {
        return beheerder_vakgeb;
    }

    public void setBeheerder_vakgeb(String beheerder_vakgeb) {
        this.beheerder_vakgeb = beheerder_vakgeb;
    }

    public String getStd_beheerder_vakgeb() {
        return std_beheerder_vakgeb;
    }

    public void setStd_beheerder_vakgeb(String std_beheerder_vakgeb) {
        this.std_beheerder_vakgeb = std_beheerder_vakgeb;
    }

    public String getBestek_nr() {
        return bestek_nr;
    }

    public void setBestek_nr(String bestek_nr) {
        this.bestek_nr = bestek_nr;
    }

    public String getX62_cluster_aard() {
        return x62_cluster_aard;
    }

    public void setX62_cluster_aard(String x62_cluster_aard) {
        this.x62_cluster_aard = x62_cluster_aard;
    }

    public String getRayon() {
        return rayon;
    }

    public void setRayon(String rayon) {
        this.rayon = rayon;
    }

    public String getX62_std_rayon() {
        return x62_std_rayon;
    }

    public void setX62_std_rayon(String x62_std_rayon) {
        this.x62_std_rayon = x62_std_rayon;
    }

    public Date getObject_begin_tijd() {
        return object_begin_tijd;
    }

    public void setObject_begin_tijd(Date object_begin_tijd) {
        this.object_begin_tijd = object_begin_tijd;
    }

    public Date getObject_eind_tijd() {
        return object_eind_tijd;
    }

    public void setObject_eind_tijd(Date object_eind_tijd) {
        this.object_eind_tijd = object_eind_tijd;
    }

    public Date getReg_begin() {
        return reg_begin;
    }

    public void setReg_begin(Date reg_begin) {
        this.reg_begin = reg_begin;
    }

    public Date getReg_eind() {
        return reg_eind;
    }

    public void setReg_eind(Date reg_eind) {
        this.reg_eind = reg_eind;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIn_onderzoek() {
        return in_onderzoek;
    }

    public void setIn_onderzoek(String in_onderzoek) {
        this.in_onderzoek = in_onderzoek;
    }

    public Double getRelatieve_hoogteligging() {
        return relatieve_hoogteligging;
    }

    public void setRelatieve_hoogteligging(Double relatieve_hoogteligging) {
        this.relatieve_hoogteligging = relatieve_hoogteligging;
    }

    public String getBronhouder() {
        return bronhouder;
    }

    public void setBronhouder(String bronhouder) {
        this.bronhouder = bronhouder;
    }

    public String getType_vegetatieobj_plus() {
        return type_vegetatieobj_plus;
    }

    public void setType_vegetatieobj_plus(String type_vegetatieobj_plus) {
        this.type_vegetatieobj_plus = type_vegetatieobj_plus;
    }

    public Date getBegin_tijd() {
        return begin_tijd;
    }

    public void setBegin_tijd(Date begin_tijd) {
        this.begin_tijd = begin_tijd;
    }

    public Date getEind_tijd() {
        return eind_tijd;
    }

    public void setEind_tijd(Date eind_tijd) {
        this.eind_tijd = eind_tijd;
    }

    public String getToelichting() {
        return toelichting;
    }

    public void setToelichting(String toelichting) {
        this.toelichting = toelichting;
    }

    public String getAfbeelding() {
        return afbeelding;
    }

    public void setAfbeelding(String afbeelding) {
        this.afbeelding = afbeelding;
    }

    public String getBeheerder() {
        return beheerder;
    }

    public void setBeheerder(String beheerder) {
        this.beheerder = beheerder;
    }

    public String getHoofdcategorie() {
        return hoofdcategorie;
    }

    public void setHoofdcategorie(String hoofdcategorie) {
        this.hoofdcategorie = hoofdcategorie;
    }

    public String getX62_std_hoofdcategorie() {
        return x62_std_hoofdcategorie;
    }

    public void setX62_std_hoofdcategorie(String x62_std_hoofdcategorie) {
        this.x62_std_hoofdcategorie = x62_std_hoofdcategorie;
    }

    public String getCategorie() {
        return categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getX62_std_categorie() {
        return x62_std_categorie;
    }

    public void setX62_std_categorie(String x62_std_categorie) {
        this.x62_std_categorie = x62_std_categorie;
    }

    public String getSubcategorie() {
        return subcategorie;
    }

    public void setSubcategorie(String subcategorie) {
        this.subcategorie = subcategorie;
    }

    public String getX62_std_subcategorie() {
        return x62_std_subcategorie;
    }

    public void setX62_std_subcategorie(String x62_std_subcategorie) {
        this.x62_std_subcategorie = x62_std_subcategorie;
    }

    public String getBoomtype() {
        return boomtype;
    }

    public void setBoomtype(String boomtype) {
        this.boomtype = boomtype;
    }

    public String getStd_boomtype() {
        return std_boomtype;
    }

    public void setStd_boomtype(String std_boomtype) {
        this.std_boomtype = std_boomtype;
    }

    public String getStandplaats() {
        return standplaats;
    }

    public void setStandplaats(String standplaats) {
        this.standplaats = standplaats;
    }

    public String getStd_standplaats() {
        return std_standplaats;
    }

    public void setStd_standplaats(String std_standplaats) {
        this.std_standplaats = std_standplaats;
    }

    public String getOntwikkelingsstadium() {
        return ontwikkelingsstadium;
    }

    public void setOntwikkelingsstadium(String ontwikkelingsstadium) {
        this.ontwikkelingsstadium = ontwikkelingsstadium;
    }

    public String getStd_ontwikkelingsstadium() {
        return std_ontwikkelingsstadium;
    }

    public void setStd_ontwikkelingsstadium(String std_ontwikkelingsstadium) {
        this.std_ontwikkelingsstadium = std_ontwikkelingsstadium;
    }

    public String getNedboomsoort() {
        return nedboomsoort;
    }

    public void setNedboomsoort(String nedboomsoort) {
        this.nedboomsoort = nedboomsoort;
    }

    public String getLatboomsoort() {
        return latboomsoort;
    }

    public void setLatboomsoort(String latboomsoort) {
        this.latboomsoort = latboomsoort;
    }

    public String getOpkroonhoogte() {
        return opkroonhoogte;
    }

    public void setOpkroonhoogte(String opkroonhoogte) {
        this.opkroonhoogte = opkroonhoogte;
    }

    public String getStd_opkroonhoogte() {
        return std_opkroonhoogte;
    }

    public void setStd_opkroonhoogte(String std_opkroonhoogte) {
        this.std_opkroonhoogte = std_opkroonhoogte;
    }

    public String getDiameter() {
        return diameter;
    }

    public void setDiameter(String diameter) {
        this.diameter = diameter;
    }

    public String getStd_diameter() {
        return std_diameter;
    }

    public void setStd_diameter(String std_diameter) {
        this.std_diameter = std_diameter;
    }

    public String getBoomhoogte() {
        return boomhoogte;
    }

    public void setBoomhoogte(String boomhoogte) {
        this.boomhoogte = boomhoogte;
    }

    public String getStd_boomhoogte() {
        return std_boomhoogte;
    }

    public void setStd_boomhoogte(String std_boomhoogte) {
        this.std_boomhoogte = std_boomhoogte;
    }

    public Double getAanlegjaar() {
        return aanlegjaar;
    }

    public void setAanlegjaar(Double aanlegjaar) {
        this.aanlegjaar = aanlegjaar;
    }

    public String getVergunningsplicht() {
        return vergunningsplicht;
    }

    public void setVergunningsplicht(String vergunningsplicht) {
        this.vergunningsplicht = vergunningsplicht;
    }

    public String getBoomrooster() {
        return boomrooster;
    }

    public void setBoomrooster(String boomrooster) {
        this.boomrooster = boomrooster;
    }

    public String getBoombeschermer() {
        return boombeschermer;
    }

    public void setBoombeschermer(String boombeschermer) {
        this.boombeschermer = boombeschermer;
    }

    public String getGrasspiegel() {
        return grasspiegel;
    }

    public void setGrasspiegel(String grasspiegel) {
        this.grasspiegel = grasspiegel;
    }

    public String getGietijzeren_boomkrans() {
        return gietijzeren_boomkrans;
    }

    public void setGietijzeren_boomkrans(String gietijzeren_boomkrans) {
        this.gietijzeren_boomkrans = gietijzeren_boomkrans;
    }

    public String getPloegindeling() {
        return ploegindeling;
    }

    public void setPloegindeling(String ploegindeling) {
        this.ploegindeling = ploegindeling;
    }

    public Date getInspectiedatum() {
        return inspectiedatum;
    }

    public void setInspectiedatum(Date inspectiedatum) {
        this.inspectiedatum = inspectiedatum;
    }

    public String getGak() {
        return gak;
    }

    public void setGak(String gak) {
        this.gak = gak;
    }

    public String getDhk() {
        return dhk;
    }

    public void setDhk(String dhk) {
        this.dhk = dhk;
    }

    public String getUtk() {
        return utk;
    }

    public void setUtk(String utk) {
        this.utk = utk;
    }

    public String getBvk() {
        return bvk;
    }

    public void setBvk(String bvk) {
        this.bvk = bvk;
    }

    public String getPzk() {
        return pzk;
    }

    public void setPzk(String pzk) {
        this.pzk = pzk;
    }

    public String getInk() {
        return ink;
    }

    public void setInk(String ink) {
        this.ink = ink;
    }

    public String getRzk() {
        return rzk;
    }

    public void setRzk(String rzk) {
        this.rzk = rzk;
    }

    public String getHgk() {
        return hgk;
    }

    public void setHgk(String hgk) {
        this.hgk = hgk;
    }

    public String getMemo_kroon() {
        return memo_kroon;
    }

    public void setMemo_kroon(String memo_kroon) {
        this.memo_kroon = memo_kroon;
    }

    public String getGas() {
        return gas;
    }

    public void setGas(String gas) {
        this.gas = gas;
    }

    public String getIns() {
        return ins;
    }

    public void setIns(String ins) {
        this.ins = ins;
    }

    public String getRzs() {
        return rzs;
    }

    public void setRzs(String rzs) {
        this.rzs = rzs;
    }

    public String getHis() {
        return his;
    }

    public void setHis(String his) {
        this.his = his;
    }

    public String getSrs() {
        return srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    public String getMbs() {
        return mbs;
    }

    public void setMbs(String mbs) {
        this.mbs = mbs;
    }

    public String getScs() {
        return scs;
    }

    public void setScs(String scs) {
        this.scs = scs;
    }

    public String getAes() {
        return aes;
    }

    public void setAes(String aes) {
        this.aes = aes;
    }

    public String getMemo_stam() {
        return memo_stam;
    }

    public void setMemo_stam(String memo_stam) {
        this.memo_stam = memo_stam;
    }

    public String getGaw() {
        return gaw;
    }

    public void setGaw(String gaw) {
        this.gaw = gaw;
    }

    public String getRzw() {
        return rzw;
    }

    public void setRzw(String rzw) {
        this.rzw = rzw;
    }

    public String getBww() {
        return bww;
    }

    public void setBww(String bww) {
        this.bww = bww;
    }

    public String getGsw() {
        return gsw;
    }

    public void setGsw(String gsw) {
        this.gsw = gsw;
    }

    public String getOvw() {
        return ovw;
    }

    public void setOvw(String ovw) {
        this.ovw = ovw;
    }

    public String getMemo_wortels() {
        return memo_wortels;
    }

    public void setMemo_wortels(String memo_wortels) {
        this.memo_wortels = memo_wortels;
    }

    public String getNoa() {
        return noa;
    }

    public void setNoa(String noa) {
        this.noa = noa;
    }

    public String getBva() {
        return bva;
    }

    public void setBva(String bva) {
        this.bva = bva;
    }

    public String getBsa() {
        return bsa;
    }

    public void setBsa(String bsa) {
        this.bsa = bsa;
    }

    public String getBra() {
        return bra;
    }

    public void setBra(String bra) {
        this.bra = bra;
    }

    public String getKva() {
        return kva;
    }

    public void setKva(String kva) {
        this.kva = kva;
    }

    public String getMemo_advies() {
        return memo_advies;
    }

    public void setMemo_advies(String memo_advies) {
        this.memo_advies = memo_advies;
    }

    public String getMemo_vta() {
        return memo_vta;
    }

    public void setMemo_vta(String memo_vta) {
        this.memo_vta = memo_vta;
    }

    public String getAfbeelding_vta() {
        return afbeelding_vta;
    }

    public void setAfbeelding_vta(String afbeelding_vta) {
        this.afbeelding_vta = afbeelding_vta;
    }

    public String getRisicoklasse() {
        return risicoklasse;
    }

    public void setRisicoklasse(String risicoklasse) {
        this.risicoklasse = risicoklasse;
    }

    public String getBoomconditie() {
        return boomconditie;
    }

    public void setBoomconditie(String boomconditie) {
        this.boomconditie = boomconditie;
    }

    public String getUrgentie_vta() {
        return urgentie_vta;
    }

    public void setUrgentie_vta(String urgentie_vta) {
        this.urgentie_vta = urgentie_vta;
    }

    public String getInspectiefrequentie() {
        return inspectiefrequentie;
    }

    public void setInspectiefrequentie(String inspectiefrequentie) {
        this.inspectiefrequentie = inspectiefrequentie;
    }

    public String getInspecteur_vta() {
        return inspecteur_vta;
    }

    public void setInspecteur_vta(String inspecteur_vta) {
        this.inspecteur_vta = inspecteur_vta;
    }

    public String getWoonplaats() {
        return woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getWijk() {
        return wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getBuurt() {
        return buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOpenbare_ruimte() {
        return openbare_ruimte;
    }

    public void setOpenbare_ruimte(String openbare_ruimte) {
        this.openbare_ruimte = openbare_ruimte;
    }

    public String getGroenobject_id() {
        return groenobject_id;
    }

    public void setGroenobject_id(String groenobject_id) {
        this.groenobject_id = groenobject_id;
    }

    public String getBijzondere_boom() {
        return bijzondere_boom;
    }

    public void setBijzondere_boom(String bijzondere_boom) {
        this.bijzondere_boom = bijzondere_boom;
    }

    public String getEigenaar() {
        return eigenaar;
    }

    public void setEigenaar(String eigenaar) {
        this.eigenaar = eigenaar;
    }

    public String getOmgevingsrisicoklasse() {
        return omgevingsrisicoklasse;
    }

    public void setOmgevingsrisicoklasse(String omgevingsrisicoklasse) {
        this.omgevingsrisicoklasse = omgevingsrisicoklasse;
    }

    public String getBoomveiligheidsklasse() {
        return boomveiligheidsklasse;
    }

    public void setBoomveiligheidsklasse(String boomveiligheidsklasse) {
        this.boomveiligheidsklasse = boomveiligheidsklasse;
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public Geometry getGeometrie() {
        return geometrie;
    }

    public void setGeometrie(Geometry geometrie) {
        this.geometrie = geometrie;
    }

    public List<TreePlanning> getPlanningen() {
        return planningen;
    }

    public void setPlanningen(List<TreePlanning> planningen) {
        this.planningen = planningen;
    }

    public List<TreeInspection> getInspecties() {
        return inspecties;
    }

    public void setInspecties(List<TreeInspection> inspecties) {
        this.inspecties = inspecties;
    }

    @Override
    public List<Feature> getChildren() {
        List<Feature> childs = new ArrayList<>();
        if (planningen != null) {
            planningen.forEach(p -> childs.add(p));
        }
        if (inspecties != null) {
            inspecties.forEach(treeInspection -> childs.add(treeInspection));
        }
        if (onderhouden != null) {
            onderhouden.forEach(onderhoud -> childs.add(onderhoud));
        }
        return childs;
    }
}
