/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.configuration;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import javax.sql.DataSource;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configuration
public class APIConfiguration {
    @Autowired
    private Environment env;

    @Bean
    public OpenAPI formAPI() {
        return new OpenAPI().info(this.metaData()).externalDocs(new ExternalDocumentation().description("B3Partners").url("\"https://b3partners.nl/\""));
    }

    @Bean
    @Primary
    public DataSource primaryDataSource() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(this.env.getProperty("spring.datasource.driverClassName"));
        dataSource.setUrl(this.env.getProperty("spring.datasource.url"));
        dataSource.setUsername(this.env.getProperty("spring.datasource.username"));
        dataSource.setPassword(this.env.getProperty("spring.datasource.password"));
        return dataSource;
    }

    @Bean(name={"tailormapDB"})
    public DataSource secondaryDataSource() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(this.env.getProperty("spring.secondDatasource.driverClassName"));
        dataSource.setUrl(this.env.getProperty("spring.secondDatasource.url"));
        dataSource.setUsername(this.env.getProperty("spring.secondDatasource.username"));
        dataSource.setPassword(this.env.getProperty("spring.secondDatasource.password"));
        return dataSource;
    }

    @Bean
    public JtsModule jtsModule() {
        return new JtsModule(new GeometryFactory(new PrecisionModel(2.0), 28992));
    }

    private Info metaData() {
        return new Info().title("GBI Form REST API").description("\"REST API for GBI Forms\"").version("1.0.0").license(new License().name("Affero GPL v3").url("https://www.gnu.org/licenses/agpl-3.0.nl.html")).contact(new Contact().name("Meine Toonen").email("meinetoonen@b3partners.nl"));
    }
}

