/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.TreeInspectionRepository;
import nl.b3p.formendpoint.repository.TreeRepository;
import nl.b3p.formendpoint.resource.Tree;
import nl.b3p.formendpoint.resource.TreeInspection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"boominspectie"})
public class FormTreeInspectionController
implements FormController<TreeInspection> {
    @Autowired
    TreeInspectionRepository repo;
    @Autowired
    TreeRepository treeRepo;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/{objectGuid}"})
    public TreeInspection get(@PathVariable String objectGuid) {
        return (TreeInspection)this.repo.findByDataGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
    }

    public List<TreeInspection> onPoint(double x, double y, double scale) {
        return new ArrayList<TreeInspection>();
    }

    @GetMapping
    public Page<TreeInspection> getAllPaged(Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    @GetMapping(value={"/unpaged"})
    public List<TreeInspection> getAll() {
        return this.repo.findAll();
    }

    @PostMapping
    public TreeInspection save(@RequestBody TreeInspection wv, String parentId) {
        Tree parent = (Tree)this.treeRepo.findByObjectGuid(parentId).orElseThrow(() -> new IllegalArgumentException("Parent niet gevonden"));
        wv.setBoom_id(parent.getObjectGuid());
        return (TreeInspection)this.repo.save((Object)wv);
    }

    @PutMapping(value={"/{objectGuid}"})
    public TreeInspection update(@PathVariable String objectGuid, @RequestBody TreeInspection wv) {
        TreeInspection orig = (TreeInspection)this.repo.findByDataGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)wv, (Object)orig);
        TreeInspection nieuw = (TreeInspection)this.repo.save((Object)orig);
        return nieuw;
    }

    @DeleteMapping(value={"/{objectGuid}"})
    public void delete(@PathVariable String objectGuid) {
        this.repo.deleteByDataGuid(objectGuid);
    }

    public Class getMaintainingClass() {
        return TreeInspection.class;
    }
}

