package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.RoadsectionRepository;
import nl.b3p.formendpoint.resource.Roadsection;
import org.locationtech.jts.geom.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
public class FormRoadsectionPartController implements FormController<Roadsection>{

    @Autowired
    RoadsectionRepository repo;

    Logger logger = LoggerFactory.getLogger(FormRoadsectionPartController.class);

    @GetMapping("/wegvakonderdeel/{objectGuid}")
    public Roadsection get(@PathVariable  String objectGuid) {
        Optional<Roadsection> ors = repo.findByObjectGuid(objectGuid);
        Roadsection rs = ors.orElseThrow( () -> new IllegalArgumentException("niet gevonden"));
        return rs;
    }

    @GetMapping(value = "/wegvakonderdelen/unpaged")
    public List<Roadsection> getAll() {
        return repo.findAll();
    }

    @GetMapping(value = "/wegvakonderdelen")
    public Page<Roadsection> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @GetMapping(value = "/wegvakonderdelen/{x}/{y}/{scale}")
    public List<Roadsection> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }

    @PostMapping("/wegvakonderdeel")
    public Roadsection save(@RequestBody Roadsection wv, String parentId){
        return repo.save(wv);
    }

    @PutMapping("/wegvakonderdeel/{objectGuid}")
    public Roadsection update(@PathVariable  String objectGuid, @RequestBody Roadsection wv){
        Roadsection orig=  repo.findByObjectGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(wv, orig, "planningen", "weginspecties");
        Roadsection nieuw = repo.save(orig);
        return nieuw;
    }

    @DeleteMapping("/wegvakonderdeel/{objectGuid}")
    public void delete(@PathVariable String objectGuid){
        repo.deleteByObjectGuid(objectGuid);
    }

    @Override
    public Class getMaintainingClass() {
        return Roadsection.class;
    }

}
