package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.TreeplanningRepository;
import nl.b3p.formendpoint.repository.TreeRepository;
import nl.b3p.formendpoint.repository.TreeplanningRepository;
import nl.b3p.formendpoint.resource.Tree;
import nl.b3p.formendpoint.resource.TreeInspection;
import nl.b3p.formendpoint.resource.TreePlanning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("boomplanning")
public class FormTreePlanningController implements FormController<TreePlanning>{

    @Autowired
    TreeplanningRepository repo;

    @Autowired
    TreeRepository treeRepo;

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping("/{objectGuid}")
    public TreePlanning get(@PathVariable String objectGuid) {
        return repo.findByDataGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));
    }

    @Override
    public List<TreePlanning> onPoint(double x, double y, double scale) {
        return new ArrayList<>();
    }

    @Override
    @GetMapping
    public Page<TreePlanning> getAllPaged(Pageable pageable) {
        return repo.findAll(pageable);
    }

    @GetMapping("/unpaged")
    public List<TreePlanning> getAll() {
        return repo.findAll();
    }

    @PostMapping
    public TreePlanning save(@RequestBody TreePlanning wv, String parentId){
        Tree parent = treeRepo.findByObjectGuid(parentId).orElseThrow( () -> new IllegalArgumentException("Parent niet gevonden"));;
        wv.setBoom_id(parent.getObjectGuid());
        return repo.save(wv);
    }

    @PutMapping("/{objectGuid}")
    public TreePlanning update(@PathVariable  String objectGuid, @RequestBody TreePlanning wv){
        TreePlanning orig=  repo.findByDataGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(wv, orig);
        TreePlanning nieuw = repo.save(orig);
        return nieuw;
    }

    @DeleteMapping("/{objectGuid}")
    public void delete(@PathVariable String objectGuid){
        repo.deleteByDataGuid(objectGuid);
    }

    @Override
    public Class getMaintainingClass() {
        return TreePlanning.class;
    }
}
