package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.ArtificialWorkPart;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface ArtificialWorkPartRepository extends JpaRepository<ArtificialWorkPart, Long> {
    Optional<ArtificialWorkPart> findById(Long id);

    Optional<ArtificialWorkPart> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<ArtificialWorkPart> findWithinPoint(Geometry area);

}
