package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.ArtificialWork;
import nl.b3p.formendpoint.resource.ArtificialWork;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface ArtificialWorkRepository extends JpaRepository<ArtificialWork, Long> {
    Optional<ArtificialWork> findById(Long id);

    Optional<ArtificialWork> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<ArtificialWork> findWithinPoint(Geometry area);
    
}
