package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.CultPlanting;
import nl.b3p.formendpoint.resource.Gbi_kw_planning_nen_tot;
import nl.b3p.formendpoint.resource.Grass;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface Gbi_kw_planning_nen_totRepository extends JpaRepository<Gbi_kw_planning_nen_tot, Long> {

    Optional<Gbi_kw_planning_nen_tot> findById(Long id);

    Optional<Gbi_kw_planning_nen_tot> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<Gbi_kw_planning_nen_tot> findWithinPoint(Geometry area);
}
