/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.controller.UserLayerController;
import nl.b3p.formendpoint.resource.Feature;
import nl.b3p.formendpoint.resource.FeaturetypeMetadata;
import nl.b3p.formendpoint.resource.GeometryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"features"})
public class FeatureController
implements FormController {
    Logger logger = LoggerFactory.getLogger(FeatureController.class);
    Map<String, FormController> controllers = new HashMap();
    @Autowired
    @Qualifier(value="tailormapDB")
    private DataSource dataSource;
    @Autowired
    private EntityManager em;
    @Autowired
    private List<FormController> ll;

    @PostConstruct
    public void init() {
        this.logger.debug("Adding formcontrollers to FeatureController...");
        HashMap<String, String> englishToDutch = new HashMap<String, String>();
        Object totalAdded = "";
        JsonSubTypes a = Feature.class.getAnnotation(JsonSubTypes.class);
        JsonSubTypes.Type[] ts = a.value();
        for (JsonSubTypes.Type type : ts) {
            englishToDutch.put(type.value().getSimpleName().toLowerCase(), type.name().toLowerCase());
        }
        englishToDutch.put("userlayer", "userlayer");
        for (FormController fc : this.ll) {
            if (fc instanceof FeatureController) continue;
            this.controllers.put((String)englishToDutch.get(fc.getMaintainingClassString()), fc);
            totalAdded = (String)totalAdded + fc.getMaintainingClassString() + ", ";
            this.logger.info("Added: " + fc.getMaintainingClassString() + " - " + fc.getClass().getSimpleName());
        }
        this.logger.debug("Added: " + (String)totalAdded);
    }

    @GetMapping(value={"/{featuretype}/{objectGuid}"})
    public Feature get(@PathVariable String featuretype, @PathVariable String objectGuid) throws Exception {
        FormController fc = this.getController(featuretype);
        return fc.get(objectGuid);
    }

    @GetMapping(value={"/info/{featureTypes}"})
    public List<FeaturetypeMetadata> featuretypeInformation(@PathVariable String[] featureTypes) {
        ArrayList<FeaturetypeMetadata> md = new ArrayList<FeaturetypeMetadata>();
        this.controllers.values().forEach(controller -> {
            if (!(controller instanceof UserLayerController)) {
                boolean b = false;
                md.add(this.getMetadata(controller));
            }
        });
        return md;
    }

    private FeaturetypeMetadata getMetadata(FormController c) {
        Object f;
        FeaturetypeMetadata fm = new FeaturetypeMetadata();
        Type[] genericInterfaces = c.getClass().getGenericInterfaces();
        Type t = genericInterfaces[0];
        Type[] types = ((ParameterizedType)t).getActualTypeArguments();
        Type resource = types[0];
        try {
            f = (Feature)((Class)resource).newInstance();
            fm.featuretypeName = f.getClazz();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        try {
            f = ((Class)resource).getDeclaredField("geometrie");
            fm.geometryAttribute = ((Field)f).getName();
            fm.geometryType = GeometryType.fromValue((String)((Field)f).getType().getSimpleName()).orElse(GeometryType.POLYGON);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return fm;
    }

    @GetMapping(value={"/unpaged"})
    public List<Feature> getAll() {
        ArrayList<Feature> fs = new ArrayList<Feature>();
        this.controllers.values().forEach(controller -> fs.addAll(controller.getAll()));
        return fs;
    }

    @GetMapping(value={"/{x}/{y}/{scale}"})
    public List<Feature> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        this.controllers.values().forEach(controller -> features.addAll(controller.onPoint(x, y, scale)));
        return features;
    }

    @GetMapping(value={"/{featureTypes}/{x}/{y}/{scale}"})
    public List<Feature> featuretypeOnPoint(@PathVariable String[] featureTypes, @PathVariable double x, @PathVariable double y, @PathVariable double scale) throws Exception {
        ArrayList<Feature> features = new ArrayList<Feature>();
        List fcs = this.getControllers(featureTypes);
        fcs.forEach(fc -> features.addAll(fc.onPoint(x, y, scale)));
        return features;
    }

    @PostMapping
    public Feature save(@RequestBody Feature f, @RequestParam(required=false) String parentId) throws Exception {
        FormController fc = this.getController(f);
        f.setObjectGuid(UUID.randomUUID().toString());
        return fc.save(f, parentId);
    }

    @PutMapping(value={"/{objectGuid}"})
    public Feature update(@PathVariable String objectGuid, @RequestBody Feature feature) throws Exception {
        FormController fc = this.getController(feature);
        return fc.update(objectGuid, feature);
    }

    @Transactional
    @DeleteMapping(value={"{featuretype}/{objectGuid}"})
    public void delete(@PathVariable String featuretype, @PathVariable String objectGuid) throws Exception {
        FormController fc = this.getController(featuretype);
        fc.delete(objectGuid);
    }

    private FormController getController(Feature f) throws Exception {
        return this.getController(f.getClazz());
    }

    private FormController getController(String featuretype) throws Exception {
        Object fc = null;
        fc = featuretype.contains("ul_") ? this.getUserLayerController(featuretype) : (FormController)this.controllers.get(featuretype);
        return fc;
    }

    private List<FormController> getControllers(String[] featuretypes) throws Exception {
        ArrayList<FormController> fcs = new ArrayList<FormController>();
        for (String ft : featuretypes) {
            if (!this.controllers.containsKey(ft)) continue;
            fcs.add((FormController)this.controllers.get(ft));
        }
        fcs.addAll(this.getUserLayerControllers(featuretypes));
        return fcs;
    }

    private List<UserLayerController> getUserLayerControllers(String[] featureTypes) throws Exception {
        ArrayList<UserLayerController> fcs = new ArrayList<UserLayerController>();
        for (String ft : featureTypes) {
            if (!ft.contains("ul_")) continue;
            fcs.add(this.getUserLayerController(ft));
        }
        return fcs;
    }

    private UserLayerController getUserLayerController(String ft) throws Exception {
        String layerId = ft.substring("ul_".length());
        UserLayerController ulc = new UserLayerController(layerId, this.dataSource, this.controllers, this.em);
        return ulc;
    }

    public Class getMaintainingClass() {
        return Feature.class;
    }

    public Feature get(String objectGuid) {
        throw new IllegalArgumentException("Not intented to be implemented");
    }

    public Page getAllPaged(Pageable pageable) {
        throw new IllegalArgumentException("Not intented to be implemented");
    }

    public void delete(String objectGuid) {
        throw new IllegalArgumentException("Not intented to be implemented");
    }
}

