/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.List;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.CultPlantingRepository;
import nl.b3p.formendpoint.resource.CultPlanting;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormCultPlantingController
implements FormController<CultPlanting> {
    @Autowired
    CultPlantingRepository repo;

    public Class getMaintainingClass() {
        return CultPlanting.class;
    }

    @GetMapping(value={"/cultbeplanting/{objectGuid}"})
    public CultPlanting get(@PathVariable String objectGuid) {
        return (CultPlanting)this.repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    public Page<CultPlanting> getAllPaged(@ParameterObject Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    public List<CultPlanting> getAll() {
        return this.repo.findAll();
    }

    public CultPlanting save(@RequestBody CultPlanting feature, String parentId) {
        return (CultPlanting)this.repo.save((Object)feature);
    }

    public CultPlanting update(@PathVariable String objectGuid, @RequestBody CultPlanting feature) {
        CultPlanting orig = (CultPlanting)this.repo.findByObjectGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)feature, (Object)orig);
        CultPlanting nieuw = (CultPlanting)this.repo.save((Object)orig);
        return nieuw;
    }

    public void delete(String objectGuid) {
        this.repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value={"/cultbeplanting/{x}/{y}/{scale}"})
    public List<CultPlanting> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        return this.repo.findWithinPoint(p.buffer(scale));
    }
}

