/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.sql.DataSource;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.resource.Feature;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserLayerController
implements FormController<Feature> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String USERLAYER_SEPARATOR = "ul_";
    private String layerId;
    private DataSource dataSource;
    private EntityManager em;
    private FormController origController;
    private String userLayerFilter = null;
    private String userLayerTable = null;
    private String userLayerOriginalTable = null;
    private String query;

    public UserLayerController() {
    }

    public UserLayerController(String layerId, DataSource ds, Map<String, FormController> controllers, EntityManager em) throws Exception {
        this.layerId = layerId;
        this.dataSource = ds;
        this.em = em;
        this.init(controllers);
        if (this.origController == null) {
            throw new IllegalArgumentException("Userlayer controller incomplete data: original controller not found for " + this.userLayerOriginalTable);
        }
        this.query = "select " + this.getColumns() + " FROM " + this.userLayerTable;
    }

    private String getColumns() {
        Field[] fields;
        ArrayList<Object> columns = new ArrayList<Object>();
        for (Field f : fields = this.origController.getMaintainingClass().getDeclaredFields()) {
            if (Geometry.class.isAssignableFrom(f.getType())) {
                columns.add("st_curvetoline(" + f.getName() + ") as " + f.getName());
                continue;
            }
            OneToMany otm = f.getAnnotation(OneToMany.class);
            if (otm != null) continue;
            String name = f.getName();
            Schema s = f.getAnnotation(Schema.class);
            if (s != null) {
                name = s.name();
            }
            columns.add(name);
        }
        return String.join((CharSequence)",", columns);
    }

    private void init(Map<String, FormController> controllers) {
        try (Connection con = this.dataSource.getConnection();){
            String queryDetails = "select layer, value, details_key from layer_details where layer = ?";
            try (PreparedStatement stmt = con.prepareStatement(queryDetails);){
                stmt.setLong(1, Long.parseLong(this.layerId));
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String key = rs.getString("details_key");
                    String value = rs.getString("value");
                    switch (key) {
                        case "userlayer_filter": {
                            this.userLayerFilter = value;
                            break;
                        }
                        case "userlayer_original_layername": {
                            this.userLayerOriginalTable = value;
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.logger.error("Error retrieving userlayer details: ", (Throwable)e);
            }
            String queryLayer = "select id, name from layer where id = ?";
            try (PreparedStatement stmt = con.prepareStatement(queryLayer);){
                stmt.setLong(1, Long.parseLong(this.layerId));
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    this.userLayerTable = rs.getString("name");
                }
            }
            catch (SQLException e) {
                this.logger.error("Error retrieving layername: ", (Throwable)e);
            }
        }
        catch (SQLException e) {
            this.logger.error("Error opening connection: ", (Throwable)e);
        }
        this.origController = controllers.get(this.sanitizeLayerName(this.userLayerOriginalTable));
    }

    private String sanitizeLayerName(String layerName) {
        if (layerName.contains(":")) {
            layerName = layerName.substring(layerName.indexOf(":") + 1);
        }
        return layerName.replace("gb_", "");
    }

    public String getMaintainingClassString() {
        return "userlayer";
    }

    public Class getMaintainingClass() {
        return null;
    }

    public Feature get(String objectGuid) {
        String sql = this.query + " WHERE  object_guid = :objectguid";
        Query q = this.em.createNativeQuery(sql, this.origController.getMaintainingClass());
        q.setParameter("objectguid", (Object)objectGuid);
        Feature l = (Feature)q.getSingleResult();
        return l;
    }

    public List<Feature> onPoint(double x, double y, double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        Geometry geom = p.buffer(scale);
        String sql = this.query + " WHERE  st_intersects(geometrie, :area) = true";
        Query q = this.em.createNativeQuery(sql, this.origController.getMaintainingClass());
        q.setParameter("area", (Object)geom);
        List l = q.getResultList();
        return l;
    }

    public Page<Feature> getAllPaged(Pageable pageable) {
        this.logger.error("Cannot save userlayer");
        return null;
    }

    public List<Feature> getAll() {
        String sql = this.query;
        Query q = this.em.createNativeQuery(sql, this.origController.getMaintainingClass());
        List l = q.getResultList();
        return l;
    }

    public Feature save(Feature feature, String parentId) {
        this.logger.error("Cannot save userlayer");
        return null;
    }

    public Feature update(String objectGuid, Feature feature) {
        this.logger.error("Cannot update userlayer");
        return null;
    }

    public void delete(String objectGuid) {
        this.logger.error("Cannot delete userlayer");
    }
}

