package nl.b3p.formendpoint.controller;


import nl.b3p.formendpoint.repository.AttributeRepository;
import nl.b3p.formendpoint.resource.koppellijst.Attribuut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import javax.persistence.EntityManager;
import java.util.*;

@RestController
public class AttributeController {

    @Autowired
    AttributeRepository repo;
/*
    @GetMapping("attributes2/{ids}")
    public Map<BigInteger,LinkedAttribute> attributes2(@PathVariable Set<Long> ids){

        // haal per id een attribuut op
            // per attribuut het domein
                // per domein de waardes
                    // per waarde de parentwaarde
                // per domein de gelinkte domeinen
                    // per gelinkt domein de waardes
                // per domein het ouderdomein
                    // per ouderdomein de waarde voor

        List<Attribuut> attrs = em.createQuery("FROM Attribuut a Where a.id in :ids",
                Attribuut.class).setParameter("ids", ids).getResultList();
        Map<Long,LinkedAttribute> linkedAttributes = new HashMap<>();
        for (Attribuut attr: attrs) {
            linkedAttributes.put(attr.getId(), processAttribute(attr));
    }
        return linkedAttributes;
    }

    private LinkedAttribute processAttribute(Attribuut attr){
        LinkedAttribute la = new LinkedAttribute();
        la.setFeatureType(attr.getObject_naam());
        la.setDomeinId(attr.getDomein().getId());
        la.setId(attr.getId());
        la.setNaam(attr.getNaam());
        la.setTabel_naam(attr.getTabel_naam());

        List<LinkedValue> values = new ArrayList<>();
        la.setValues(values);
        attr.getDomein().getWaardes().forEach(waarde ->{

            LinkedValue lv = domeinWaardeToLinkedValue(waarde);
            values.add(lv);

            List<Domeinwaarde> linkedDomeinWaardes = waarde.getLinkedDomeinwaardes();
            Map<Long, List<LinkedValue>> childsPerDomain = lv.getChildDomainValues();
            for (Domeinwaarde childwaarde: linkedDomeinWaardes) {
                Long childdomeinid = childwaarde.getDomein().getId();
                if(!childsPerDomain.containsKey(childdomeinid)){
                    childsPerDomain.put(childdomeinid, new ArrayList<>());
        }
                LinkedValue child = domeinWaardeToLinkedValue(childwaarde);
                childsPerDomain.get(childdomeinid).add(child);
            }
        });
        return la;
    }

    private LinkedValue domeinWaardeToLinkedValue(Domeinwaarde waarde){
        LinkedValue lv = new LinkedValue();
        lv.setId(waarde.getId());
        lv.setDomeinid(waarde.getDomein().getId());
        lv.setValue(waarde.getWaarde());
        Domein parent = waarde.getDomein().getParent();
        if(parent != null){
            lv.setParentdomeinid(parent.getId());
            lv.setParentValue(retrieveParentValue(parent, waarde));
        }
        return lv;
    }

    private LinkedValue retrieveParentValue(Domein parent, Domeinwaarde current){
        List<Domeinwaarde> parentwaardes = parent.getWaardes();
        for (Domeinwaarde parentwaarde: parentwaardes) {
            List<Domeinwaarde> linkedParentWaardes = parentwaarde.getLinkedDomeinwaardes();
            for (Domeinwaarde value : linkedParentWaardes) {
                if (value.getDomein().getId() == current.getDomein().getId() && value.getWaarde().equals(current.getWaarde())) {
                    return domeinWaardeToLinkedValue(parentwaarde);
                }
            }
        }
        return null;
    }

    @GetMapping("attributes")
    public Page<Attribuut> paged(@ParameterObject Pageable page){
        return repo.findAll(page);
    }
*/
    @GetMapping("attributes/{ids}")
    public List<Attribuut> attributes(@PathVariable Set<Long> ids){
        return repo.findById(ids);
    }
}
