package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.WellRepository;
import nl.b3p.formendpoint.resource.Well;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

@RestController
public class FormWellController implements FormController<Well> {

    @Autowired
    WellRepository repo;

    @Override
    public Class getMaintainingClass() {
        return Well.class;
    }

    @GetMapping("/rioolput/{objectGuid}")
    public Well get(@PathVariable String objectGuid) {
        Optional<Well> maybe = repo.findByObjectGuid(objectGuid);
        Well well = maybe.orElseThrow();

        return well;
    }

    @Override
    public Page<Well> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @Override
    public List<Well> getAll() {
        return repo.findAll();
    }

    @Override
    public Well save(@RequestBody Well feature, String parentId) {
        return repo.save(feature);
    }

    @Override
    public Well update(@PathVariable String objectGuid, @RequestBody Well feature) {
        Well orig=  repo.findByObjectGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(feature, orig, "planningen", "inspecties");
        Well nieuw = repo.save(orig);
        return nieuw;
    }

    @Override
    public void delete(String objectGuid) {
        repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value = "/rioolput/{x}/{y}/{scale}")
    public List<Well> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }

}
