package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.Gbi_kw_planning_nen_totRepository;
import nl.b3p.formendpoint.resource.Gbi_kw_planning_nen_tot;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
@RestController
public class Gbi_kw_planning_nen_totController implements FormController<Gbi_kw_planning_nen_tot> {

    @Autowired
    Gbi_kw_planning_nen_totRepository repo;

    @Override
    public Class getMaintainingClass() {
        return Gbi_kw_planning_nen_tot.class;
    }

    @GetMapping("/gbi_kw_planning_nen_tot/{objectGuid}")
    public Gbi_kw_planning_nen_tot get(@PathVariable String objectGuid) {
        return repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    @Override
    public Page<Gbi_kw_planning_nen_tot> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @Override
    public List<Gbi_kw_planning_nen_tot> getAll() {
        return repo.findAll();
    }

    @Override
    public Gbi_kw_planning_nen_tot save(@RequestBody Gbi_kw_planning_nen_tot feature, String parentId) {
        return repo.save(feature);
    }

    @Override
    public Gbi_kw_planning_nen_tot update(@PathVariable String id, @RequestBody Gbi_kw_planning_nen_tot feature) {
        Gbi_kw_planning_nen_tot orig=  repo.findById(Long.parseLong(id)).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(feature, orig, "planningen", "inspecties");
        Gbi_kw_planning_nen_tot nieuw = repo.save(orig);
        return nieuw;
    }

    @Override
    public void delete(String id) {
        repo.deleteById(Long.parseLong(id));
    }

    @GetMapping(value = "/gbi_kw_planning_nen_tot/{x}/{y}/{scale}")
    public List<Gbi_kw_planning_nen_tot> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }


}
