package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Entity(name = "gb_weginspectie")
@Schema(
        name = "Weginspectie",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RoadInspection implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @Schema(name = "data_guid")
    private String dataGuid;

    @Schema(name = "wegvakonderdeel_id")
    @Column(name = "wegvakonderdeel_id")
    private String wegvakonderdeelId;

    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date inspectiedatum;
    private Long a1_rafeling;
    private Long a3_dwarsonvlakheid;
    private Long a4_oneffenheden;
    private Long a5_scheurvorming;
    private Long a7_randschade;
    private Long e1_dwarsonvlakheid;
    private String opmerking;
    private String inspectieronde;
    private String inspecteur;

    @Override
    public String getObjectGuid() {
        return this.dataGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.dataGuid = objectGuid;
    }

    @Override
    public List<Feature> getChildren() {
        return null;
    }


    public String getDataGuid() {
        return dataGuid;
    }

    public void setDataGuid(String dataGuid) {
        this.dataGuid = dataGuid;
    }

    public String getWegvakonderdeelId() {
        return wegvakonderdeelId;
    }

    public void setWegvakonderdeelId(String wegvakonderdeelId) {
        this.wegvakonderdeelId = wegvakonderdeelId;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getInspectiedatum() {
        return inspectiedatum;
    }

    public void setInspectiedatum(Date inspectiedatum) {
        this.inspectiedatum = inspectiedatum;
    }

    public Long getA1_rafeling() {
        return a1_rafeling;
    }

    public void setA1_rafeling(Long a1_rafeling) {
        this.a1_rafeling = a1_rafeling;
    }

    public Long getA3_dwarsonvlakheid() {
        return a3_dwarsonvlakheid;
    }

    public void setA3_dwarsonvlakheid(Long a3_dwarsonvlakheid) {
        this.a3_dwarsonvlakheid = a3_dwarsonvlakheid;
    }

    public Long getA4_oneffenheden() {
        return a4_oneffenheden;
    }

    public void setA4_oneffenheden(Long a4_oneffenheden) {
        this.a4_oneffenheden = a4_oneffenheden;
    }

    public Long getA5_scheurvorming() {
        return a5_scheurvorming;
    }

    public void setA5_scheurvorming(Long a5_scheurvorming) {
        this.a5_scheurvorming = a5_scheurvorming;
    }

    public Long getA7_randschade() {
        return a7_randschade;
    }

    public void setA7_randschade(Long a7_randschade) {
        this.a7_randschade = a7_randschade;
    }

    public Long getE1_dwarsonvlakheid() {
        return e1_dwarsonvlakheid;
    }

    public void setE1_dwarsonvlakheid(Long e1_dwarsonvlakheid) {
        this.e1_dwarsonvlakheid = e1_dwarsonvlakheid;
    }

    public String getOpmerking() {
        return opmerking;
    }

    public void setOpmerking(String opmerking) {
        this.opmerking = opmerking;
    }

    public String getInspectieronde() {
        return inspectieronde;
    }

    public void setInspectieronde(String inspectieronde) {
        this.inspectieronde = inspectieronde;
    }

    public String getInspecteur() {
        return inspecteur;
    }

    public void setInspecteur(String inspecteur) {
        this.inspecteur = inspecteur;
    }
}
