package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;

@Entity(name = "gb_rioolput_planning")
@Schema(
        name = "RioolputPlanning",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class WellPlanning implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Schema(name = "data_guid")
    private String dataGuid;
    private String maatregel_rlput;
    private String maatregeltype;
    private Double jaarvanuitvoering;
    private Double hoeveelheid;
    private Double kosten;
    private Character gepland_uitgevoerd;
    private String planstatus;
    private Double frequentie;
    private String rioolput_id;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDataGuid() {
        return dataGuid;
    }

    public void setDataGuid(String dataGuid) {
        this.dataGuid = dataGuid;
    }

    public String getMaatregel_rlput() {
        return maatregel_rlput;
    }

    public void setMaatregel_rlput(String maatregel_rlput) {
        this.maatregel_rlput = maatregel_rlput;
    }

    public String getMaatregeltype() {
        return maatregeltype;
    }

    public void setMaatregeltype(String maatregeltype) {
        this.maatregeltype = maatregeltype;
    }

    public Double getJaarvanuitvoering() {
        return jaarvanuitvoering;
    }

    public void setJaarvanuitvoering(Double jaarvanuitvoering) {
        this.jaarvanuitvoering = jaarvanuitvoering;
    }

    public Double getHoeveelheid() {
        return hoeveelheid;
    }

    public void setHoeveelheid(Double hoeveelheid) {
        this.hoeveelheid = hoeveelheid;
    }

    public Double getKosten() {
        return kosten;
    }

    public void setKosten(Double kosten) {
        this.kosten = kosten;
    }

    public Character getGepland_uitgevoerd() {
        return gepland_uitgevoerd;
    }

    public void setGepland_uitgevoerd(Character gepland_uitgevoerd) {
        this.gepland_uitgevoerd = gepland_uitgevoerd;
    }

    public String getPlanstatus() {
        return planstatus;
    }

    public void setPlanstatus(String planstatus) {
        this.planstatus = planstatus;
    }

    public Double getFrequentie() {
        return frequentie;
    }

    public void setFrequentie(Double frequentie) {
        this.frequentie = frequentie;
    }

    public String getRioolput_id() {
        return rioolput_id;
    }

    public void setRioolput_id(String rioolput_id) {
        this.rioolput_id = rioolput_id;
    }

    @Override
    public String getObjectGuid() {
        return dataGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.dataGuid = objectGuid;
    }
}
