/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.List;
import java.util.Optional;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.PlanterRepository;
import nl.b3p.formendpoint.resource.Planter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormPlanterController
implements FormController<Planter> {
    @Autowired
    PlanterRepository repo;
    Logger logger = LoggerFactory.getLogger(FormPlanterController.class);

    @GetMapping(value={"/plantenbak/{objectGuid}"})
    public Planter get(@PathVariable String objectGuid) {
        Optional ors = this.repo.findByObjectGuid(objectGuid);
        Planter rs = (Planter)ors.orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        return rs;
    }

    @GetMapping(value={"/plantenbakken/unpaged"})
    public List<Planter> getAll() {
        return this.repo.findAll();
    }

    @GetMapping(value={"/plantenbakken"})
    public Page<Planter> getAllPaged(@ParameterObject Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    @GetMapping(value={"/plantenbakken/{x}/{y}/{scale}"})
    public List<Planter> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        return this.repo.findWithinPoint(p.buffer(scale));
    }

    @PostMapping(value={"/plantenbak"})
    public Planter save(@RequestBody Planter wv, String parentId) {
        return (Planter)this.repo.save((Object)wv);
    }

    @PutMapping(value={"/plantenbak/{objectGuid}"})
    public Planter update(@PathVariable String objectGuid, @RequestBody Planter wv) {
        Planter orig = (Planter)this.repo.findByObjectGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)wv, (Object)orig, (String[])new String[]{"planningen"});
        Planter nieuw = (Planter)this.repo.save((Object)orig);
        return nieuw;
    }

    @DeleteMapping(value={"/plantenbak/{objectGuid}"})
    public void delete(@PathVariable String objectGuid) {
        this.repo.deleteByObjectGuid(objectGuid);
    }

    public Class getMaintainingClass() {
        return Planter.class;
    }
}

