package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.IMBORGreenObjectRepository;
import nl.b3p.formendpoint.resource.IMBORGreenObject;
import nl.b3p.formendpoint.resource.IMBORGreenObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

@RestController
public class IMBORGreenObjectController implements FormController<IMBORGreenObject>{


    @Autowired
    IMBORGreenObjectRepository repo;

    @Override
    public Class getMaintainingClass() {
        return IMBORGreenObject.class;
    }

    @GetMapping("/imborgroenobject/{objectGuid}")
    public IMBORGreenObject get(@PathVariable String objectGuid) {
        Optional<IMBORGreenObject> maybe = repo.findByImborIdentificatie(objectGuid);
        IMBORGreenObject IMBORGreenObject = maybe.orElseThrow();

        return IMBORGreenObject;
    }

    @Override
    public Page<IMBORGreenObject> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @Override
    public List<IMBORGreenObject> getAll() {
        return repo.findAll();
    }

    @Override
    public IMBORGreenObject save(@RequestBody IMBORGreenObject feature, String parentId) {
        return repo.save(feature);
    }

    @Override
    public IMBORGreenObject update(@PathVariable String objectGuid, @RequestBody IMBORGreenObject feature) {
        IMBORGreenObject orig=  repo.findByImborIdentificatie(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(feature, orig, "planningen", "inspecties");
        IMBORGreenObject nieuw = repo.save(orig);
        return nieuw;
    }

    @Override
    public void delete(String objectGuid) {
        repo.deleteByImborIdentificatie(objectGuid);
    }

    @GetMapping(value = "/imborgroenobject/{x}/{y}/{scale}")
    public List<IMBORGreenObject> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }

    
}
