package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.IMBORGreenObject;
import nl.b3p.formendpoint.resource.IMBORTree;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface IMBORGreenObjectRepository extends JpaRepository<IMBORGreenObject, String> {

    public Optional<IMBORGreenObject> findByImborIdentificatie(String imbor_identificatie);
    public void deleteByImborIdentificatie(String imbor_identificatie);

    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<IMBORGreenObject> findWithinPoint(Geometry area);
}
