package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.hibernate.annotations.ColumnTransformer;
import org.locationtech.jts.geom.Geometry;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

@Entity(name = "V_verhardingsobject")
@Schema(
        name = "IMBORVerhardingsobject",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class IMBORHardeningObject implements Feature, Serializable {
    @Id
    private String imborIdentificatie;
    private Date verwijderdatum;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 tijdstipregistratie;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 objectbegintijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 lv_publicatiedatum;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 eindregistratie;
    private Integer	 maximalevalhoogte;
    private Integer	 technischelevensduur;
    private Integer	 relatievehoogteligging;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 mutatiedatum;
    private Integer	 lengtekunstgras;
    private Integer	 jaaruitgevoerdonderhoud;
    private Integer	 jaarconserveren;
    private Integer	 aantaldeklagen;
    private Integer	 aantaltussenlagen;
    private Integer	 aantalonderlagen;
    private Integer	 aanleghoogte;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 objecteindtijd;
    private Integer	 jaarvanaanleg;
    @Schema(implementation = org.geojson.Geometry.class)
    @Basic(optional = false)
    @ColumnTransformer(
            read = "st_curvetoline(geometrie)"
    )
    private Geometry geometrie;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 opleverdatum;
    private Integer	 breedte;
    private Integer	 dikteconstructie;
    private Integer	 theoretischeindjaar;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 eindegarantieperiode;
    private Integer	 lengte;
    private Integer	 lengtevoegen;
    private Integer	 praktischeindjaar;
    private Integer	 levensduur;
    private Integer	 omtrek;
    private Integer	 aanschafprijs;
    private Integer	 oppervlakte;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date	 begingarantieperiode;
    private Integer	 bergendvermogen;
    private Integer	 id;
    private String bgt_opmerking;
    private String bor_type;
    private String bor_functie;
    private String bor_fysiekvoorkomen;
    private String grondsoort;
    private String typeconstructie;
    private String typefundering;
    private String typevoegvulling;
    private String wegvaknummer;
    private String kwaliteitsniveaugewenst;
    private String type;
    private String typeplus;
    private Boolean optalud;
    private String taludsteilte;
    private String bgtfysiekvoorkomen;
    private String imgeofysiekvoorkomen;
    private String belasting;
    private String typevoeg;
    private String wegtypebestaand;
    private String objectnummer;
    private String wegnummer;
    private String ondergrondcode;
    private String kleur;
    private String materiaal;
    private String waterdoorlatendheid;
    private String grondsoortplus;
    private Boolean geluidsreducerend;
    private String zettingsgevoeligheid;
    private String plaatsorientatie;
    private String zettingsgevoeligheidplus;
    private String vulmateriaalkunstgras;
    private String afmeting;
    private String gemengdebestrating;
    private String vegen;
    private String soortvoeg;
    private String typeplus2;
    private String formaat;
    private Boolean verhoogdeligging;
    private String wegas;
    private String wegvak;
    private String wegcategoriedv;
    private String wegcategoriedvplus;
    private String typerijstrook;
    private String aanofvrijliggend;
    private Boolean draagkrachtig;
    private String rijstrook;
    private String wegfunctie;
    private String modaliteit;
    private String kwaliteitsniveauactueel;
    private String conditiescore;
    private String legverband;
    private String buurt;
    private String onderhoudsplichtige;
    private String openbareruimte;
    private String imgeo_identificatie;
    private String typebeheerder;
    private String typebeheerderplus;
    private String typeeigenaar;
    private String typeligging;
    private String beheergebied;
    private String gebiedstype;
    private String waterschap;
    private String postcode;

    private String aangemaaktdoor;
    private String gewijzigddoor;
    private String status;
    private String typeeigenaarplus;
    private String wijk;
    private String woonplaats;
    private String conversieid;
    private String gebruiksfunctie;
    private String gemeente;
    private String beheervak_id;
    private String stadsdeelofkern;
    private String memo;
    private String bronhouder;
    private String bgt_type;
    private String bgt_functie;
    private String plus_type;
    private String plus_functie;
    private String bgt_status;
    private Boolean inonderzoek;
    private String inwinning;

    @Override
    public String getObjectGuid() {
        return imborIdentificatie;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        imborIdentificatie = objectGuid;
    }

    public String getImborIdentificatie() {
        return imborIdentificatie;
    }

    public void setImborIdentificatie(String imborIdentificatie) {
        this.imborIdentificatie = imborIdentificatie;
    }

    public Date getVerwijderdatum() {
        return verwijderdatum;
    }

    public void setVerwijderdatum(Date verwijderdatum) {
        this.verwijderdatum = verwijderdatum;
    }

    public Date getTijdstipregistratie() {
        return tijdstipregistratie;
    }

    public void setTijdstipregistratie(Date tijdstipregistratie) {
        this.tijdstipregistratie = tijdstipregistratie;
    }

    public Date getObjectbegintijd() {
        return objectbegintijd;
    }

    public void setObjectbegintijd(Date objectbegintijd) {
        this.objectbegintijd = objectbegintijd;
    }

    public Date getLv_publicatiedatum() {
        return lv_publicatiedatum;
    }

    public void setLv_publicatiedatum(Date lv_publicatiedatum) {
        this.lv_publicatiedatum = lv_publicatiedatum;
    }

    public Date getEindregistratie() {
        return eindregistratie;
    }

    public void setEindregistratie(Date eindregistratie) {
        this.eindregistratie = eindregistratie;
    }

    public Integer getMaximalevalhoogte() {
        return maximalevalhoogte;
    }

    public void setMaximalevalhoogte(Integer maximalevalhoogte) {
        this.maximalevalhoogte = maximalevalhoogte;
    }

    public Integer getTechnischelevensduur() {
        return technischelevensduur;
    }

    public void setTechnischelevensduur(Integer technischelevensduur) {
        this.technischelevensduur = technischelevensduur;
    }

    public Integer getRelatievehoogteligging() {
        return relatievehoogteligging;
    }

    public void setRelatievehoogteligging(Integer relatievehoogteligging) {
        this.relatievehoogteligging = relatievehoogteligging;
    }

    public Date getMutatiedatum() {
        return mutatiedatum;
    }

    public void setMutatiedatum(Date mutatiedatum) {
        this.mutatiedatum = mutatiedatum;
    }

    public Integer getLengtekunstgras() {
        return lengtekunstgras;
    }

    public void setLengtekunstgras(Integer lengtekunstgras) {
        this.lengtekunstgras = lengtekunstgras;
    }

    public Integer getJaaruitgevoerdonderhoud() {
        return jaaruitgevoerdonderhoud;
    }

    public void setJaaruitgevoerdonderhoud(Integer jaaruitgevoerdonderhoud) {
        this.jaaruitgevoerdonderhoud = jaaruitgevoerdonderhoud;
    }

    public Integer getJaarconserveren() {
        return jaarconserveren;
    }

    public void setJaarconserveren(Integer jaarconserveren) {
        this.jaarconserveren = jaarconserveren;
    }

    public Integer getAantaldeklagen() {
        return aantaldeklagen;
    }

    public void setAantaldeklagen(Integer aantaldeklagen) {
        this.aantaldeklagen = aantaldeklagen;
    }

    public Integer getAantaltussenlagen() {
        return aantaltussenlagen;
    }

    public void setAantaltussenlagen(Integer aantaltussenlagen) {
        this.aantaltussenlagen = aantaltussenlagen;
    }

    public Integer getAantalonderlagen() {
        return aantalonderlagen;
    }

    public void setAantalonderlagen(Integer aantalonderlagen) {
        this.aantalonderlagen = aantalonderlagen;
    }

    public Integer getAanleghoogte() {
        return aanleghoogte;
    }

    public void setAanleghoogte(Integer aanleghoogte) {
        this.aanleghoogte = aanleghoogte;
    }

    public Date getObjecteindtijd() {
        return objecteindtijd;
    }

    public void setObjecteindtijd(Date objecteindtijd) {
        this.objecteindtijd = objecteindtijd;
    }

    public Integer getJaarvanaanleg() {
        return jaarvanaanleg;
    }

    public void setJaarvanaanleg(Integer jaarvanaanleg) {
        this.jaarvanaanleg = jaarvanaanleg;
    }

    public Geometry getGeometrie() {
        return geometrie;
    }

    public void setGeometrie(Geometry geometrie) {
        this.geometrie = geometrie;
    }

    public Date getOpleverdatum() {
        return opleverdatum;
    }

    public void setOpleverdatum(Date opleverdatum) {
        this.opleverdatum = opleverdatum;
    }

    public Integer getBreedte() {
        return breedte;
    }

    public void setBreedte(Integer breedte) {
        this.breedte = breedte;
    }

    public Integer getDikteconstructie() {
        return dikteconstructie;
    }

    public void setDikteconstructie(Integer dikteconstructie) {
        this.dikteconstructie = dikteconstructie;
    }

    public Integer getTheoretischeindjaar() {
        return theoretischeindjaar;
    }

    public void setTheoretischeindjaar(Integer theoretischeindjaar) {
        this.theoretischeindjaar = theoretischeindjaar;
    }

    public Date getEindegarantieperiode() {
        return eindegarantieperiode;
    }

    public void setEindegarantieperiode(Date eindegarantieperiode) {
        this.eindegarantieperiode = eindegarantieperiode;
    }

    public Integer getLengte() {
        return lengte;
    }

    public void setLengte(Integer lengte) {
        this.lengte = lengte;
    }

    public Integer getLengtevoegen() {
        return lengtevoegen;
    }

    public void setLengtevoegen(Integer lengtevoegen) {
        this.lengtevoegen = lengtevoegen;
    }

    public Integer getPraktischeindjaar() {
        return praktischeindjaar;
    }

    public void setPraktischeindjaar(Integer praktischeindjaar) {
        this.praktischeindjaar = praktischeindjaar;
    }

    public Integer getLevensduur() {
        return levensduur;
    }

    public void setLevensduur(Integer levensduur) {
        this.levensduur = levensduur;
    }

    public Integer getOmtrek() {
        return omtrek;
    }

    public void setOmtrek(Integer omtrek) {
        this.omtrek = omtrek;
    }

    public Integer getAanschafprijs() {
        return aanschafprijs;
    }

    public void setAanschafprijs(Integer aanschafprijs) {
        this.aanschafprijs = aanschafprijs;
    }

    public Integer getOppervlakte() {
        return oppervlakte;
    }

    public void setOppervlakte(Integer oppervlakte) {
        this.oppervlakte = oppervlakte;
    }

    public Date getBegingarantieperiode() {
        return begingarantieperiode;
    }

    public void setBegingarantieperiode(Date begingarantieperiode) {
        this.begingarantieperiode = begingarantieperiode;
    }

    public Integer getBergendvermogen() {
        return bergendvermogen;
    }

    public void setBergendvermogen(Integer bergendvermogen) {
        this.bergendvermogen = bergendvermogen;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBgt_opmerking() {
        return bgt_opmerking;
    }

    public void setBgt_opmerking(String bgt_opmerking) {
        this.bgt_opmerking = bgt_opmerking;
    }

    public String getBor_type() {
        return bor_type;
    }

    public void setBor_type(String bor_type) {
        this.bor_type = bor_type;
    }

    public String getBor_functie() {
        return bor_functie;
    }

    public void setBor_functie(String bor_functie) {
        this.bor_functie = bor_functie;
    }

    public String getBor_fysiekvoorkomen() {
        return bor_fysiekvoorkomen;
    }

    public void setBor_fysiekvoorkomen(String bor_fysiekvoorkomen) {
        this.bor_fysiekvoorkomen = bor_fysiekvoorkomen;
    }

    public String getGrondsoort() {
        return grondsoort;
    }

    public void setGrondsoort(String grondsoort) {
        this.grondsoort = grondsoort;
    }

    public String getTypeconstructie() {
        return typeconstructie;
    }

    public void setTypeconstructie(String typeconstructie) {
        this.typeconstructie = typeconstructie;
    }

    public String getTypefundering() {
        return typefundering;
    }

    public void setTypefundering(String typefundering) {
        this.typefundering = typefundering;
    }

    public String getTypevoegvulling() {
        return typevoegvulling;
    }

    public void setTypevoegvulling(String typevoegvulling) {
        this.typevoegvulling = typevoegvulling;
    }

    public String getWegvaknummer() {
        return wegvaknummer;
    }

    public void setWegvaknummer(String wegvaknummer) {
        this.wegvaknummer = wegvaknummer;
    }

    public String getKwaliteitsniveaugewenst() {
        return kwaliteitsniveaugewenst;
    }

    public void setKwaliteitsniveaugewenst(String kwaliteitsniveaugewenst) {
        this.kwaliteitsniveaugewenst = kwaliteitsniveaugewenst;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeplus() {
        return typeplus;
    }

    public void setTypeplus(String typeplus) {
        this.typeplus = typeplus;
    }

    public Boolean getOptalud() {
        return optalud;
    }

    public void setOptalud(Boolean optalud) {
        this.optalud = optalud;
    }

    public String getTaludsteilte() {
        return taludsteilte;
    }

    public void setTaludsteilte(String taludsteilte) {
        this.taludsteilte = taludsteilte;
    }

    public String getBgtfysiekvoorkomen() {
        return bgtfysiekvoorkomen;
    }

    public void setBgtfysiekvoorkomen(String bgtfysiekvoorkomen) {
        this.bgtfysiekvoorkomen = bgtfysiekvoorkomen;
    }

    public String getImgeofysiekvoorkomen() {
        return imgeofysiekvoorkomen;
    }

    public void setImgeofysiekvoorkomen(String imgeofysiekvoorkomen) {
        this.imgeofysiekvoorkomen = imgeofysiekvoorkomen;
    }

    public String getBelasting() {
        return belasting;
    }

    public void setBelasting(String belasting) {
        this.belasting = belasting;
    }

    public String getTypevoeg() {
        return typevoeg;
    }

    public void setTypevoeg(String typevoeg) {
        this.typevoeg = typevoeg;
    }

    public String getWegtypebestaand() {
        return wegtypebestaand;
    }

    public void setWegtypebestaand(String wegtypebestaand) {
        this.wegtypebestaand = wegtypebestaand;
    }

    public String getObjectnummer() {
        return objectnummer;
    }

    public void setObjectnummer(String objectnummer) {
        this.objectnummer = objectnummer;
    }

    public String getWegnummer() {
        return wegnummer;
    }

    public void setWegnummer(String wegnummer) {
        this.wegnummer = wegnummer;
    }

    public String getOndergrondcode() {
        return ondergrondcode;
    }

    public void setOndergrondcode(String ondergrondcode) {
        this.ondergrondcode = ondergrondcode;
    }

    public String getKleur() {
        return kleur;
    }

    public void setKleur(String kleur) {
        this.kleur = kleur;
    }

    public String getMateriaal() {
        return materiaal;
    }

    public void setMateriaal(String materiaal) {
        this.materiaal = materiaal;
    }

    public String getWaterdoorlatendheid() {
        return waterdoorlatendheid;
    }

    public void setWaterdoorlatendheid(String waterdoorlatendheid) {
        this.waterdoorlatendheid = waterdoorlatendheid;
    }

    public String getGrondsoortplus() {
        return grondsoortplus;
    }

    public void setGrondsoortplus(String grondsoortplus) {
        this.grondsoortplus = grondsoortplus;
    }

    public Boolean getGeluidsreducerend() {
        return geluidsreducerend;
    }

    public void setGeluidsreducerend(Boolean geluidsreducerend) {
        this.geluidsreducerend = geluidsreducerend;
    }

    public String getZettingsgevoeligheid() {
        return zettingsgevoeligheid;
    }

    public void setZettingsgevoeligheid(String zettingsgevoeligheid) {
        this.zettingsgevoeligheid = zettingsgevoeligheid;
    }

    public String getPlaatsorientatie() {
        return plaatsorientatie;
    }

    public void setPlaatsorientatie(String plaatsorientatie) {
        this.plaatsorientatie = plaatsorientatie;
    }

    public String getZettingsgevoeligheidplus() {
        return zettingsgevoeligheidplus;
    }

    public void setZettingsgevoeligheidplus(String zettingsgevoeligheidplus) {
        this.zettingsgevoeligheidplus = zettingsgevoeligheidplus;
    }

    public String getVulmateriaalkunstgras() {
        return vulmateriaalkunstgras;
    }

    public void setVulmateriaalkunstgras(String vulmateriaalkunstgras) {
        this.vulmateriaalkunstgras = vulmateriaalkunstgras;
    }

    public String getAfmeting() {
        return afmeting;
    }

    public void setAfmeting(String afmeting) {
        this.afmeting = afmeting;
    }

    public String getGemengdebestrating() {
        return gemengdebestrating;
    }

    public void setGemengdebestrating(String gemengdebestrating) {
        this.gemengdebestrating = gemengdebestrating;
    }

    public String getVegen() {
        return vegen;
    }

    public void setVegen(String vegen) {
        this.vegen = vegen;
    }

    public String getSoortvoeg() {
        return soortvoeg;
    }

    public void setSoortvoeg(String soortvoeg) {
        this.soortvoeg = soortvoeg;
    }

    public String getTypeplus2() {
        return typeplus2;
    }

    public void setTypeplus2(String typeplus2) {
        this.typeplus2 = typeplus2;
    }

    public String getFormaat() {
        return formaat;
    }

    public void setFormaat(String formaat) {
        this.formaat = formaat;
    }

    public Boolean getVerhoogdeligging() {
        return verhoogdeligging;
    }

    public void setVerhoogdeligging(Boolean verhoogdeligging) {
        this.verhoogdeligging = verhoogdeligging;
    }

    public String getWegas() {
        return wegas;
    }

    public void setWegas(String wegas) {
        this.wegas = wegas;
    }

    public String getWegvak() {
        return wegvak;
    }

    public void setWegvak(String wegvak) {
        this.wegvak = wegvak;
    }

    public String getWegcategoriedv() {
        return wegcategoriedv;
    }

    public void setWegcategoriedv(String wegcategoriedv) {
        this.wegcategoriedv = wegcategoriedv;
    }

    public String getWegcategoriedvplus() {
        return wegcategoriedvplus;
    }

    public void setWegcategoriedvplus(String wegcategoriedvplus) {
        this.wegcategoriedvplus = wegcategoriedvplus;
    }

    public String getTyperijstrook() {
        return typerijstrook;
    }

    public void setTyperijstrook(String typerijstrook) {
        this.typerijstrook = typerijstrook;
    }

    public String getAanofvrijliggend() {
        return aanofvrijliggend;
    }

    public void setAanofvrijliggend(String aanofvrijliggend) {
        this.aanofvrijliggend = aanofvrijliggend;
    }

    public Boolean getDraagkrachtig() {
        return draagkrachtig;
    }

    public void setDraagkrachtig(Boolean draagkrachtig) {
        this.draagkrachtig = draagkrachtig;
    }

    public String getRijstrook() {
        return rijstrook;
    }

    public void setRijstrook(String rijstrook) {
        this.rijstrook = rijstrook;
    }

    public String getWegfunctie() {
        return wegfunctie;
    }

    public void setWegfunctie(String wegfunctie) {
        this.wegfunctie = wegfunctie;
    }

    public String getModaliteit() {
        return modaliteit;
    }

    public void setModaliteit(String modaliteit) {
        this.modaliteit = modaliteit;
    }

    public String getKwaliteitsniveauactueel() {
        return kwaliteitsniveauactueel;
    }

    public void setKwaliteitsniveauactueel(String kwaliteitsniveauactueel) {
        this.kwaliteitsniveauactueel = kwaliteitsniveauactueel;
    }

    public String getConditiescore() {
        return conditiescore;
    }

    public void setConditiescore(String conditiescore) {
        this.conditiescore = conditiescore;
    }

    public String getLegverband() {
        return legverband;
    }

    public void setLegverband(String legverband) {
        this.legverband = legverband;
    }

    public String getBuurt() {
        return buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOnderhoudsplichtige() {
        return onderhoudsplichtige;
    }

    public void setOnderhoudsplichtige(String onderhoudsplichtige) {
        this.onderhoudsplichtige = onderhoudsplichtige;
    }

    public String getOpenbareruimte() {
        return openbareruimte;
    }

    public void setOpenbareruimte(String openbareruimte) {
        this.openbareruimte = openbareruimte;
    }

    public String getImgeo_identificatie() {
        return imgeo_identificatie;
    }

    public void setImgeo_identificatie(String imgeo_identificatie) {
        this.imgeo_identificatie = imgeo_identificatie;
    }

    public String getTypebeheerder() {
        return typebeheerder;
    }

    public void setTypebeheerder(String typebeheerder) {
        this.typebeheerder = typebeheerder;
    }

    public String getTypebeheerderplus() {
        return typebeheerderplus;
    }

    public void setTypebeheerderplus(String typebeheerderplus) {
        this.typebeheerderplus = typebeheerderplus;
    }

    public String getTypeeigenaar() {
        return typeeigenaar;
    }

    public void setTypeeigenaar(String typeeigenaar) {
        this.typeeigenaar = typeeigenaar;
    }

    public String getTypeligging() {
        return typeligging;
    }

    public void setTypeligging(String typeligging) {
        this.typeligging = typeligging;
    }

    public String getBeheergebied() {
        return beheergebied;
    }

    public void setBeheergebied(String beheergebied) {
        this.beheergebied = beheergebied;
    }

    public String getGebiedstype() {
        return gebiedstype;
    }

    public void setGebiedstype(String gebiedstype) {
        this.gebiedstype = gebiedstype;
    }

    public String getWaterschap() {
        return waterschap;
    }

    public void setWaterschap(String waterschap) {
        this.waterschap = waterschap;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getAangemaaktdoor() {
        return aangemaaktdoor;
    }

    public void setAangemaaktdoor(String aangemaaktdoor) {
        this.aangemaaktdoor = aangemaaktdoor;
    }

    public String getGewijzigddoor() {
        return gewijzigddoor;
    }

    public void setGewijzigddoor(String gewijzigddoor) {
        this.gewijzigddoor = gewijzigddoor;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTypeeigenaarplus() {
        return typeeigenaarplus;
    }

    public void setTypeeigenaarplus(String typeeigenaarplus) {
        this.typeeigenaarplus = typeeigenaarplus;
    }

    public String getWijk() {
        return wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getWoonplaats() {
        return woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getConversieid() {
        return conversieid;
    }

    public void setConversieid(String conversieid) {
        this.conversieid = conversieid;
    }

    public String getGebruiksfunctie() {
        return gebruiksfunctie;
    }

    public void setGebruiksfunctie(String gebruiksfunctie) {
        this.gebruiksfunctie = gebruiksfunctie;
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public String getBeheervak_id() {
        return beheervak_id;
    }

    public void setBeheervak_id(String beheervak_id) {
        this.beheervak_id = beheervak_id;
    }

    public String getStadsdeelofkern() {
        return stadsdeelofkern;
    }

    public void setStadsdeelofkern(String stadsdeelofkern) {
        this.stadsdeelofkern = stadsdeelofkern;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBronhouder() {
        return bronhouder;
    }

    public void setBronhouder(String bronhouder) {
        this.bronhouder = bronhouder;
    }

    public String getBgt_type() {
        return bgt_type;
    }

    public void setBgt_type(String bgt_type) {
        this.bgt_type = bgt_type;
    }

    public String getBgt_functie() {
        return bgt_functie;
    }

    public void setBgt_functie(String bgt_functie) {
        this.bgt_functie = bgt_functie;
    }

    public String getPlus_type() {
        return plus_type;
    }

    public void setPlus_type(String plus_type) {
        this.plus_type = plus_type;
    }

    public String getPlus_functie() {
        return plus_functie;
    }

    public void setPlus_functie(String plus_functie) {
        this.plus_functie = plus_functie;
    }

    public String getBgt_status() {
        return bgt_status;
    }

    public void setBgt_status(String bgt_status) {
        this.bgt_status = bgt_status;
    }

    public Boolean getInonderzoek() {
        return inonderzoek;
    }

    public void setInonderzoek(Boolean inonderzoek) {
        this.inonderzoek = inonderzoek;
    }

    public String getInwinning() {
        return inwinning;
    }

    public void setInwinning(String inwinning) {
        this.inwinning = inwinning;
    }
}
