package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.hibernate.annotations.ColumnTransformer;
import org.locationtech.jts.geom.Geometry;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


@Entity(name = "V_Boom")
@Schema(
        name = "IMBORBoom",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class IMBORTree implements Feature, Serializable {

    @Id
    private String imborIdentificatie;
    private Integer takvrijestam;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date mutatiedatum;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date objecteindtijd;
    private Integer jaarvanaanleg;
    private Integer takvrijeruimtetotgebouw;
    private Integer kiemjaar;

    @Schema(implementation = org.geojson.Geometry.class)
    @Basic(optional = false)
    @ColumnTransformer(
            read = "st_curvetoline(geometrie)"
    )
    private Geometry geometrie;
    private Integer boomhoogteactueel;
    private Integer kroonvolume;
    private Integer leeftijd;
    private Integer takvrijezoneprimair;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date opleverdatum;
    private Integer monetaireboomwaarde;
    private Integer theoretischeindjaar;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date verwijderdatum;
    private Integer vrijedoorrijhoogte;
    private Integer vrijedoorrijhoogteprimair;
    private Integer vrijedoorrijhoogtesecundair;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date tijdstipregistratie;
    private Integer knipoppervlakte;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date objectbegintijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date lv_publicatiedatum;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date eindregistratie;
    private Integer relatievehoogteligging;
    private Integer stamdiameter;
    private Integer takvrijezonesecundair;
    private Integer id;
    private String bgt_type;
    private String bgt_functie;
    private String plus_type;
    private String plus_functie;
    private String bgt_status;
    private Boolean inonderzoek;
    private String inwinning;
    private String bgt_opmerking;
    private String bor_type;
    private String bor_functie;
    private String bor_fysiekvoorkomen;
    private String bereikbaarheidplus;
    private Boolean ecologischbeheer;
    private String grondsoort;
    private String soortnaam;
    private String typestandplaats;
    private String typestandplaatsplus;
    private String kwaliteitsniveaugewenst;
    private Boolean afvoeren;
    private String bereikbaarheid;
    private String objectnummer;
    private String leverancier;
    private String grondsoortplus;
    private String kweker;
    private Boolean beschermdefloraenfauna;
    private String knipfrequentie;
    private String kwaliteitsniveauactueel;
    private String conditiescore;
    private String snoeifrequentie;
    private String boomspiegel;
    private String groeifase;
    private String groeiplaatsinrichting;
    private String boomhoogteklasseactueel;
    private String kroondiameterklasseactueel;
    private String stamdiameterklasse;
    private String typebeschermingsstatus;
    private String typebeschermingsstatusplus;
    private String typeomgevingsrisicoklasse;
    private String vrijetakval;
    private String type;
    private String typeplus;
    private String boombeschermer_id;
    private String boomgroep;
    private String boomveiligheidsklasse;
    private String controlefrequentie;
    private String boomvoorziening;
    private String snoeifase;
    private String typevermeerderingsvorm;
    private String boomhoogteklasseeindbeeld;
    private String kroondiameterklasseeindbeeld;
    private String beoogdeomlooptijd;
    private String boombeeld;
    private Boolean verplantbaar;
    private String beleidsstatus;
    private Boolean herplantplicht;
    private String feestverlichting;
    private Boolean verplant;
    private Boolean meerstammig;
    private String transponder;
    private String beoogdeopkroonhoogte;
    private String actueleopkroonhoogte;
    private String buurt;
    private String onderhoudsplichtige;
    private String openbareruimte;
    private String imgeo_identificatie;
    private String typebeheerder;
    private String typebeheerderplus;
    private String typeeigenaar;
    private String typeligging;
    private String beheergebied;
    private String gebiedstype;
    private String waterschap;
    private String postcode;
    private String aangemaaktdoor;
    private String gewijzigddoor;
    private String status;
    private String typeeigenaarplus;
    private String wijk;
    private String woonplaats;
    private String conversieid;
    private String gebruiksfunctie;
    private String gemeente;
    private String beheervak_id;
    private String stadsdeelofkern;
    private String memo;
    private String bronhouder;

    @Override
    public String getObjectGuid() {
        return imborIdentificatie;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        imborIdentificatie = objectGuid;
    }

    public String getImborIdentificatie() {
        return imborIdentificatie;
    }

    public void setImborIdentificatie(String imborIdentificatie) {
        this.imborIdentificatie = imborIdentificatie;
    }

    public Integer getTakvrijestam() {
        return takvrijestam;
    }

    public void setTakvrijestam(Integer takvrijestam) {
        this.takvrijestam = takvrijestam;
    }

    public Date getMutatiedatum() {
        return mutatiedatum;
    }

    public void setMutatiedatum(Date mutatiedatum) {
        this.mutatiedatum = mutatiedatum;
    }

    public Date getObjecteindtijd() {
        return objecteindtijd;
    }

    public void setObjecteindtijd(Date objecteindtijd) {
        this.objecteindtijd = objecteindtijd;
    }

    public Integer getJaarvanaanleg() {
        return jaarvanaanleg;
    }

    public void setJaarvanaanleg(Integer jaarvanaanleg) {
        this.jaarvanaanleg = jaarvanaanleg;
    }

    public Integer getTakvrijeruimtetotgebouw() {
        return takvrijeruimtetotgebouw;
    }

    public void setTakvrijeruimtetotgebouw(Integer takvrijeruimtetotgebouw) {
        this.takvrijeruimtetotgebouw = takvrijeruimtetotgebouw;
    }

    public Integer getKiemjaar() {
        return kiemjaar;
    }

    public void setKiemjaar(Integer kiemjaar) {
        this.kiemjaar = kiemjaar;
    }

    public Geometry getGeometrie() {
        return geometrie;
    }

    public void setGeometrie(Geometry geometrie) {
        this.geometrie = geometrie;
    }

    public Integer getBoomhoogteactueel() {
        return boomhoogteactueel;
    }

    public void setBoomhoogteactueel(Integer boomhoogteactueel) {
        this.boomhoogteactueel = boomhoogteactueel;
    }

    public Integer getKroonvolume() {
        return kroonvolume;
    }

    public void setKroonvolume(Integer kroonvolume) {
        this.kroonvolume = kroonvolume;
    }

    public Integer getLeeftijd() {
        return leeftijd;
    }

    public void setLeeftijd(Integer leeftijd) {
        this.leeftijd = leeftijd;
    }

    public Integer getTakvrijezoneprimair() {
        return takvrijezoneprimair;
    }

    public void setTakvrijezoneprimair(Integer takvrijezoneprimair) {
        this.takvrijezoneprimair = takvrijezoneprimair;
    }

    public Date getOpleverdatum() {
        return opleverdatum;
    }

    public void setOpleverdatum(Date opleverdatum) {
        this.opleverdatum = opleverdatum;
    }

    public Integer getMonetaireboomwaarde() {
        return monetaireboomwaarde;
    }

    public void setMonetaireboomwaarde(Integer monetaireboomwaarde) {
        this.monetaireboomwaarde = monetaireboomwaarde;
    }

    public Integer getTheoretischeindjaar() {
        return theoretischeindjaar;
    }

    public void setTheoretischeindjaar(Integer theoretischeindjaar) {
        this.theoretischeindjaar = theoretischeindjaar;
    }

    public Date getVerwijderdatum() {
        return verwijderdatum;
    }

    public void setVerwijderdatum(Date verwijderdatum) {
        this.verwijderdatum = verwijderdatum;
    }

    public Integer getVrijedoorrijhoogte() {
        return vrijedoorrijhoogte;
    }

    public void setVrijedoorrijhoogte(Integer vrijedoorrijhoogte) {
        this.vrijedoorrijhoogte = vrijedoorrijhoogte;
    }

    public Integer getVrijedoorrijhoogteprimair() {
        return vrijedoorrijhoogteprimair;
    }

    public void setVrijedoorrijhoogteprimair(Integer vrijedoorrijhoogteprimair) {
        this.vrijedoorrijhoogteprimair = vrijedoorrijhoogteprimair;
    }

    public Integer getVrijedoorrijhoogtesecundair() {
        return vrijedoorrijhoogtesecundair;
    }

    public void setVrijedoorrijhoogtesecundair(Integer vrijedoorrijhoogtesecundair) {
        this.vrijedoorrijhoogtesecundair = vrijedoorrijhoogtesecundair;
    }

    public Date getTijdstipregistratie() {
        return tijdstipregistratie;
    }

    public void setTijdstipregistratie(Date tijdstipregistratie) {
        this.tijdstipregistratie = tijdstipregistratie;
    }

    public Integer getKnipoppervlakte() {
        return knipoppervlakte;
    }

    public void setKnipoppervlakte(Integer knipoppervlakte) {
        this.knipoppervlakte = knipoppervlakte;
    }

    public Date getObjectbegintijd() {
        return objectbegintijd;
    }

    public void setObjectbegintijd(Date objectbegintijd) {
        this.objectbegintijd = objectbegintijd;
    }

    public Date getLv_publicatiedatum() {
        return lv_publicatiedatum;
    }

    public void setLv_publicatiedatum(Date lv_publicatiedatum) {
        this.lv_publicatiedatum = lv_publicatiedatum;
    }

    public Date getEindregistratie() {
        return eindregistratie;
    }

    public void setEindregistratie(Date eindregistratie) {
        this.eindregistratie = eindregistratie;
    }

    public Integer getRelatievehoogteligging() {
        return relatievehoogteligging;
    }

    public void setRelatievehoogteligging(Integer relatievehoogteligging) {
        this.relatievehoogteligging = relatievehoogteligging;
    }

    public Integer getStamdiameter() {
        return stamdiameter;
    }

    public void setStamdiameter(Integer stamdiameter) {
        this.stamdiameter = stamdiameter;
    }

    public Integer getTakvrijezonesecundair() {
        return takvrijezonesecundair;
    }

    public void setTakvrijezonesecundair(Integer takvrijezonesecundair) {
        this.takvrijezonesecundair = takvrijezonesecundair;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBgt_type() {
        return bgt_type;
    }

    public void setBgt_type(String bgt_type) {
        this.bgt_type = bgt_type;
    }

    public String getBgt_functie() {
        return bgt_functie;
    }

    public void setBgt_functie(String bgt_functie) {
        this.bgt_functie = bgt_functie;
    }

    public String getPlus_type() {
        return plus_type;
    }

    public void setPlus_type(String plus_type) {
        this.plus_type = plus_type;
    }

    public String getPlus_functie() {
        return plus_functie;
    }

    public void setPlus_functie(String plus_functie) {
        this.plus_functie = plus_functie;
    }

    public String getBgt_status() {
        return bgt_status;
    }

    public void setBgt_status(String bgt_status) {
        this.bgt_status = bgt_status;
    }

    public Boolean getInonderzoek() {
        return inonderzoek;
    }

    public void setInonderzoek(Boolean inonderzoek) {
        this.inonderzoek = inonderzoek;
    }

    public String getInwinning() {
        return inwinning;
    }

    public void setInwinning(String inwinning) {
        this.inwinning = inwinning;
    }

    public String getBgt_opmerking() {
        return bgt_opmerking;
    }

    public void setBgt_opmerking(String bgt_opmerking) {
        this.bgt_opmerking = bgt_opmerking;
    }

    public String getBor_type() {
        return bor_type;
    }

    public void setBor_type(String bor_type) {
        this.bor_type = bor_type;
    }

    public String getBor_functie() {
        return bor_functie;
    }

    public void setBor_functie(String bor_functie) {
        this.bor_functie = bor_functie;
    }

    public String getBor_fysiekvoorkomen() {
        return bor_fysiekvoorkomen;
    }

    public void setBor_fysiekvoorkomen(String bor_fysiekvoorkomen) {
        this.bor_fysiekvoorkomen = bor_fysiekvoorkomen;
    }

    public String getBereikbaarheidplus() {
        return bereikbaarheidplus;
    }

    public void setBereikbaarheidplus(String bereikbaarheidplus) {
        this.bereikbaarheidplus = bereikbaarheidplus;
    }

    public Boolean getEcologischbeheer() {
        return ecologischbeheer;
    }

    public void setEcologischbeheer(Boolean ecologischbeheer) {
        this.ecologischbeheer = ecologischbeheer;
    }

    public String getGrondsoort() {
        return grondsoort;
    }

    public void setGrondsoort(String grondsoort) {
        this.grondsoort = grondsoort;
    }

    public String getSoortnaam() {
        return soortnaam;
    }

    public void setSoortnaam(String soortnaam) {
        this.soortnaam = soortnaam;
    }

    public String getTypestandplaats() {
        return typestandplaats;
    }

    public void setTypestandplaats(String typestandplaats) {
        this.typestandplaats = typestandplaats;
    }

    public String getTypestandplaatsplus() {
        return typestandplaatsplus;
    }

    public void setTypestandplaatsplus(String typestandplaatsplus) {
        this.typestandplaatsplus = typestandplaatsplus;
    }

    public String getKwaliteitsniveaugewenst() {
        return kwaliteitsniveaugewenst;
    }

    public void setKwaliteitsniveaugewenst(String kwaliteitsniveaugewenst) {
        this.kwaliteitsniveaugewenst = kwaliteitsniveaugewenst;
    }

    public Boolean getAfvoeren() {
        return afvoeren;
    }

    public void setAfvoeren(Boolean afvoeren) {
        this.afvoeren = afvoeren;
    }

    public String getBereikbaarheid() {
        return bereikbaarheid;
    }

    public void setBereikbaarheid(String bereikbaarheid) {
        this.bereikbaarheid = bereikbaarheid;
    }

    public String getObjectnummer() {
        return objectnummer;
    }

    public void setObjectnummer(String objectnummer) {
        this.objectnummer = objectnummer;
    }

    public String getLeverancier() {
        return leverancier;
    }

    public void setLeverancier(String leverancier) {
        this.leverancier = leverancier;
    }

    public String getGrondsoortplus() {
        return grondsoortplus;
    }

    public void setGrondsoortplus(String grondsoortplus) {
        this.grondsoortplus = grondsoortplus;
    }

    public String getKweker() {
        return kweker;
    }

    public void setKweker(String kweker) {
        this.kweker = kweker;
    }

    public Boolean getBeschermdefloraenfauna() {
        return beschermdefloraenfauna;
    }

    public void setBeschermdefloraenfauna(Boolean beschermdefloraenfauna) {
        this.beschermdefloraenfauna = beschermdefloraenfauna;
    }

    public String getKnipfrequentie() {
        return knipfrequentie;
    }

    public void setKnipfrequentie(String knipfrequentie) {
        this.knipfrequentie = knipfrequentie;
    }

    public String getKwaliteitsniveauactueel() {
        return kwaliteitsniveauactueel;
    }

    public void setKwaliteitsniveauactueel(String kwaliteitsniveauactueel) {
        this.kwaliteitsniveauactueel = kwaliteitsniveauactueel;
    }

    public String getConditiescore() {
        return conditiescore;
    }

    public void setConditiescore(String conditiescore) {
        this.conditiescore = conditiescore;
    }

    public String getSnoeifrequentie() {
        return snoeifrequentie;
    }

    public void setSnoeifrequentie(String snoeifrequentie) {
        this.snoeifrequentie = snoeifrequentie;
    }

    public String getBoomspiegel() {
        return boomspiegel;
    }

    public void setBoomspiegel(String boomspiegel) {
        this.boomspiegel = boomspiegel;
    }

    public String getGroeifase() {
        return groeifase;
    }

    public void setGroeifase(String groeifase) {
        this.groeifase = groeifase;
    }

    public String getGroeiplaatsinrichting() {
        return groeiplaatsinrichting;
    }

    public void setGroeiplaatsinrichting(String groeiplaatsinrichting) {
        this.groeiplaatsinrichting = groeiplaatsinrichting;
    }

    public String getBoomhoogteklasseactueel() {
        return boomhoogteklasseactueel;
    }

    public void setBoomhoogteklasseactueel(String boomhoogteklasseactueel) {
        this.boomhoogteklasseactueel = boomhoogteklasseactueel;
    }

    public String getKroondiameterklasseactueel() {
        return kroondiameterklasseactueel;
    }

    public void setKroondiameterklasseactueel(String kroondiameterklasseactueel) {
        this.kroondiameterklasseactueel = kroondiameterklasseactueel;
    }

    public String getStamdiameterklasse() {
        return stamdiameterklasse;
    }

    public void setStamdiameterklasse(String stamdiameterklasse) {
        this.stamdiameterklasse = stamdiameterklasse;
    }

    public String getTypebeschermingsstatus() {
        return typebeschermingsstatus;
    }

    public void setTypebeschermingsstatus(String typebeschermingsstatus) {
        this.typebeschermingsstatus = typebeschermingsstatus;
    }

    public String getTypebeschermingsstatusplus() {
        return typebeschermingsstatusplus;
    }

    public void setTypebeschermingsstatusplus(String typebeschermingsstatusplus) {
        this.typebeschermingsstatusplus = typebeschermingsstatusplus;
    }

    public String getTypeomgevingsrisicoklasse() {
        return typeomgevingsrisicoklasse;
    }

    public void setTypeomgevingsrisicoklasse(String typeomgevingsrisicoklasse) {
        this.typeomgevingsrisicoklasse = typeomgevingsrisicoklasse;
    }

    public String getVrijetakval() {
        return vrijetakval;
    }

    public void setVrijetakval(String vrijetakval) {
        this.vrijetakval = vrijetakval;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeplus() {
        return typeplus;
    }

    public void setTypeplus(String typeplus) {
        this.typeplus = typeplus;
    }

    public String getBoombeschermer_id() {
        return boombeschermer_id;
    }

    public void setBoombeschermer_id(String boombeschermer_id) {
        this.boombeschermer_id = boombeschermer_id;
    }

    public String getBoomgroep() {
        return boomgroep;
    }

    public void setBoomgroep(String boomgroep) {
        this.boomgroep = boomgroep;
    }

    public String getBoomveiligheidsklasse() {
        return boomveiligheidsklasse;
    }

    public void setBoomveiligheidsklasse(String boomveiligheidsklasse) {
        this.boomveiligheidsklasse = boomveiligheidsklasse;
    }

    public String getControlefrequentie() {
        return controlefrequentie;
    }

    public void setControlefrequentie(String controlefrequentie) {
        this.controlefrequentie = controlefrequentie;
    }

    public String getBoomvoorziening() {
        return boomvoorziening;
    }

    public void setBoomvoorziening(String boomvoorziening) {
        this.boomvoorziening = boomvoorziening;
    }

    public String getSnoeifase() {
        return snoeifase;
    }

    public void setSnoeifase(String snoeifase) {
        this.snoeifase = snoeifase;
    }

    public String getTypevermeerderingsvorm() {
        return typevermeerderingsvorm;
    }

    public void setTypevermeerderingsvorm(String typevermeerderingsvorm) {
        this.typevermeerderingsvorm = typevermeerderingsvorm;
    }

    public String getBoomhoogteklasseeindbeeld() {
        return boomhoogteklasseeindbeeld;
    }

    public void setBoomhoogteklasseeindbeeld(String boomhoogteklasseeindbeeld) {
        this.boomhoogteklasseeindbeeld = boomhoogteklasseeindbeeld;
    }

    public String getKroondiameterklasseeindbeeld() {
        return kroondiameterklasseeindbeeld;
    }

    public void setKroondiameterklasseeindbeeld(String kroondiameterklasseeindbeeld) {
        this.kroondiameterklasseeindbeeld = kroondiameterklasseeindbeeld;
    }

    public String getBeoogdeomlooptijd() {
        return beoogdeomlooptijd;
    }

    public void setBeoogdeomlooptijd(String beoogdeomlooptijd) {
        this.beoogdeomlooptijd = beoogdeomlooptijd;
    }

    public String getBoombeeld() {
        return boombeeld;
    }

    public void setBoombeeld(String boombeeld) {
        this.boombeeld = boombeeld;
    }

    public Boolean getVerplantbaar() {
        return verplantbaar;
    }

    public void setVerplantbaar(Boolean verplantbaar) {
        this.verplantbaar = verplantbaar;
    }

    public String getBeleidsstatus() {
        return beleidsstatus;
    }

    public void setBeleidsstatus(String beleidsstatus) {
        this.beleidsstatus = beleidsstatus;
    }

    public Boolean getHerplantplicht() {
        return herplantplicht;
    }

    public void setHerplantplicht(Boolean herplantplicht) {
        this.herplantplicht = herplantplicht;
    }

    public String getFeestverlichting() {
        return feestverlichting;
    }

    public void setFeestverlichting(String feestverlichting) {
        this.feestverlichting = feestverlichting;
    }

    public Boolean getVerplant() {
        return verplant;
    }

    public void setVerplant(Boolean verplant) {
        this.verplant = verplant;
    }

    public Boolean getMeerstammig() {
        return meerstammig;
    }

    public void setMeerstammig(Boolean meerstammig) {
        this.meerstammig = meerstammig;
    }

    public String getTransponder() {
        return transponder;
    }

    public void setTransponder(String transponder) {
        this.transponder = transponder;
    }

    public String getBeoogdeopkroonhoogte() {
        return beoogdeopkroonhoogte;
    }

    public void setBeoogdeopkroonhoogte(String beoogdeopkroonhoogte) {
        this.beoogdeopkroonhoogte = beoogdeopkroonhoogte;
    }

    public String getActueleopkroonhoogte() {
        return actueleopkroonhoogte;
    }

    public void setActueleopkroonhoogte(String actueleopkroonhoogte) {
        this.actueleopkroonhoogte = actueleopkroonhoogte;
    }

    public String getBuurt() {
        return buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOnderhoudsplichtige() {
        return onderhoudsplichtige;
    }

    public void setOnderhoudsplichtige(String onderhoudsplichtige) {
        this.onderhoudsplichtige = onderhoudsplichtige;
    }

    public String getOpenbareruimte() {
        return openbareruimte;
    }

    public void setOpenbareruimte(String openbareruimte) {
        this.openbareruimte = openbareruimte;
    }

    public String getImgeo_identificatie() {
        return imgeo_identificatie;
    }

    public void setImgeo_identificatie(String imgeo_identificatie) {
        this.imgeo_identificatie = imgeo_identificatie;
    }

    public String getTypebeheerder() {
        return typebeheerder;
    }

    public void setTypebeheerder(String typebeheerder) {
        this.typebeheerder = typebeheerder;
    }

    public String getTypebeheerderplus() {
        return typebeheerderplus;
    }

    public void setTypebeheerderplus(String typebeheerderplus) {
        this.typebeheerderplus = typebeheerderplus;
    }

    public String getTypeeigenaar() {
        return typeeigenaar;
    }

    public void setTypeeigenaar(String typeeigenaar) {
        this.typeeigenaar = typeeigenaar;
    }

    public String getTypeligging() {
        return typeligging;
    }

    public void setTypeligging(String typeligging) {
        this.typeligging = typeligging;
    }

    public String getBeheergebied() {
        return beheergebied;
    }

    public void setBeheergebied(String beheergebied) {
        this.beheergebied = beheergebied;
    }

    public String getGebiedstype() {
        return gebiedstype;
    }

    public void setGebiedstype(String gebiedstype) {
        this.gebiedstype = gebiedstype;
    }

    public String getWaterschap() {
        return waterschap;
    }

    public void setWaterschap(String waterschap) {
        this.waterschap = waterschap;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getAangemaaktdoor() {
        return aangemaaktdoor;
    }

    public void setAangemaaktdoor(String aangemaaktdoor) {
        this.aangemaaktdoor = aangemaaktdoor;
    }

    public String getGewijzigddoor() {
        return gewijzigddoor;
    }

    public void setGewijzigddoor(String gewijzigddoor) {
        this.gewijzigddoor = gewijzigddoor;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTypeeigenaarplus() {
        return typeeigenaarplus;
    }

    public void setTypeeigenaarplus(String typeeigenaarplus) {
        this.typeeigenaarplus = typeeigenaarplus;
    }

    public String getWijk() {
        return wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getWoonplaats() {
        return woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getConversieid() {
        return conversieid;
    }

    public void setConversieid(String conversieid) {
        this.conversieid = conversieid;
    }

    public String getGebruiksfunctie() {
        return gebruiksfunctie;
    }

    public void setGebruiksfunctie(String gebruiksfunctie) {
        this.gebruiksfunctie = gebruiksfunctie;
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public String getBeheervak_id() {
        return beheervak_id;
    }

    public void setBeheervak_id(String beheervak_id) {
        this.beheervak_id = beheervak_id;
    }

    public String getStadsdeelofkern() {
        return stadsdeelofkern;
    }

    public void setStadsdeelofkern(String stadsdeelofkern) {
        this.stadsdeelofkern = stadsdeelofkern;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBronhouder() {
        return bronhouder;
    }

    public void setBronhouder(String bronhouder) {
        this.bronhouder = bronhouder;
    }
}
