package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.locationtech.jts.geom.LineString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity(name = "gb_mech_leiding")
@Schema(
        name = "MechLeiding",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MechanicalDuct implements Feature, Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;


    @Schema(implementation = org.geojson.Geometry.class)
    @Basic(optional = false)
    private LineString geometrie;

    @Schema(name = "object_guid")
    private String objectGuid;

    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(referencedColumnName = "objectGuid", name = "mech_leiding_id")
    private List<MechanicalDuctPlanning> planningen = new ArrayList<>();

    @OneToOne
    @JoinColumn(referencedColumnName = "objectGuid", name = "pompput_id")
    private Well pompput;

    @OneToOne
    @JoinColumn(referencedColumnName = "objectGuid", name = "lozingsput_id")
    private Well lozingsput;

    private String imgeo_id;
    private String bbv;
    private String domein;
    private String std_domein;
    private String beheercluster;
    private String std_beheercluster;
    private String structuurelement;
    private String std_structuurelement;
    private String beheerder_vakgeb;
    private String std_beheerder_vakgeb;
    private String bestek_nr;
    private String x62_cluster_aard;
    private String rayon;
    private String x62_std_rayon;
    private String status;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_eind_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_begin;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_eind;
    private Double afwijkendedieptelegging;
    private String detailverwijzing;
    private String eisvoorzorgsmaatregel;
    private Double geonauwkeurigheidxy;
    private String materiaal_leiding;
    private String product_leiding;
    private String toelichting_imkl;
    private String verhoogd_risico;
    private Double aantal_buizen;
    private Double diameter;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date eind_tijd;
    private String toelichting;
    private String afbeelding;
    private String beheerder;
    private String hoofdcategorie;
    private String x62_std_hoofdcategorie;
    private String categorie;
    private String x62_std_categorie;
    private String subcategorie;
    private String x62_std_subcategorie;
    private String persleidingtype;
    private String std_persleidingtype;
    private Double aanlegjaar;
    private Double lengte;
    private String grondsoort;
    private String std_grondsoort;
    private String bovenliggende_verharding;
    private Double diepte_begin;
    private Double diepte_max;
    private Double diepte_eind;
    private String waterslagvoorziening;
    private Double ontluchtingspunten;
    private String materiaal_rioolleiding;
    private String std_materiaal_rioolleiding;
    private String stroomgebied;
    private String bemalingsgebied;
    private String stelseltype;
    private String std_stelseltype;
    private String buistype;
    private String std_buistype;
    private String woonplaats;
    private String wijk;
    private String buurt;
    private String openbare_ruimte;
    private String type_leiding;
    private String drukklasse;
    private String funderingstype;
    private Double hoogte;
    private Double wandruwheid;
    private Double wandruwheid_bb;
    private Double wandruwheid_bo;
    private String leverancier_fabrikant;
    private String materiaal_gwsw;
    private String vorm;
    private String toegankelijk;
    private String verbindingstype;
    private Double vervuilingsgraad;
    private Double wanddikte;
    private String wion_thema;
    private String revisietekening;
    private String mech_leidingtype_gwsw;
    private String status_functioneren;
    private String gemeente;
    private String cons_onderdeel_id;
    private String sw_gebied_id;
    private String stelsel_id;
    private String mech_leiding_id;
    private Double breedte;

    @Override
    public List<Feature> getChildren() {
        List<Feature> childs = new ArrayList<>();
        if (lozingsput != null) {
            childs.add(lozingsput);
        }
        if (pompput != null) {
            childs.add(pompput);
        }

        if (planningen != null) {
            planningen.forEach(grassPlanning -> childs.add(grassPlanning));
        }
        return childs;
    }


    public LineString getGeometrie() {
        return geometrie;
    }

    public void setGeometrie(LineString geometrie) {
        this.geometrie = geometrie;
    }

    @Override
    public String getObjectGuid() {
        return objectGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
    }

    public String getImgeo_id() {
        return imgeo_id;
    }

    public void setImgeo_id(String imgeo_id) {
        this.imgeo_id = imgeo_id;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBbv() {
        return bbv;
    }

    public void setBbv(String bbv) {
        this.bbv = bbv;
    }

    public String getDomein() {
        return domein;
    }

    public void setDomein(String domein) {
        this.domein = domein;
    }

    public String getStd_domein() {
        return std_domein;
    }

    public void setStd_domein(String std_domein) {
        this.std_domein = std_domein;
    }

    public String getBeheercluster() {
        return beheercluster;
    }

    public void setBeheercluster(String beheercluster) {
        this.beheercluster = beheercluster;
    }

    public String getStd_beheercluster() {
        return std_beheercluster;
    }

    public void setStd_beheercluster(String std_beheercluster) {
        this.std_beheercluster = std_beheercluster;
    }

    public String getStructuurelement() {
        return structuurelement;
    }

    public void setStructuurelement(String structuurelement) {
        this.structuurelement = structuurelement;
    }

    public String getStd_structuurelement() {
        return std_structuurelement;
    }

    public void setStd_structuurelement(String std_structuurelement) {
        this.std_structuurelement = std_structuurelement;
    }

    public String getBeheerder_vakgeb() {
        return beheerder_vakgeb;
    }

    public void setBeheerder_vakgeb(String beheerder_vakgeb) {
        this.beheerder_vakgeb = beheerder_vakgeb;
    }

    public String getStd_beheerder_vakgeb() {
        return std_beheerder_vakgeb;
    }

    public void setStd_beheerder_vakgeb(String std_beheerder_vakgeb) {
        this.std_beheerder_vakgeb = std_beheerder_vakgeb;
    }

    public String getBestek_nr() {
        return bestek_nr;
    }

    public void setBestek_nr(String bestek_nr) {
        this.bestek_nr = bestek_nr;
    }

    public String getX62_cluster_aard() {
        return x62_cluster_aard;
    }

    public void setX62_cluster_aard(String x62_cluster_aard) {
        this.x62_cluster_aard = x62_cluster_aard;
    }

    public String getRayon() {
        return rayon;
    }

    public void setRayon(String rayon) {
        this.rayon = rayon;
    }

    public String getX62_std_rayon() {
        return x62_std_rayon;
    }

    public void setX62_std_rayon(String x62_std_rayon) {
        this.x62_std_rayon = x62_std_rayon;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getObject_begin_tijd() {
        return object_begin_tijd;
    }

    public void setObject_begin_tijd(Date object_begin_tijd) {
        this.object_begin_tijd = object_begin_tijd;
    }

    public Date getObject_eind_tijd() {
        return object_eind_tijd;
    }

    public void setObject_eind_tijd(Date object_eind_tijd) {
        this.object_eind_tijd = object_eind_tijd;
    }

    public Date getReg_begin() {
        return reg_begin;
    }

    public void setReg_begin(Date reg_begin) {
        this.reg_begin = reg_begin;
    }

    public Date getReg_eind() {
        return reg_eind;
    }

    public void setReg_eind(Date reg_eind) {
        this.reg_eind = reg_eind;
    }

    public Double getAfwijkendedieptelegging() {
        return afwijkendedieptelegging;
    }

    public void setAfwijkendedieptelegging(Double afwijkendedieptelegging) {
        this.afwijkendedieptelegging = afwijkendedieptelegging;
    }

    public String getDetailverwijzing() {
        return detailverwijzing;
    }

    public void setDetailverwijzing(String detailverwijzing) {
        this.detailverwijzing = detailverwijzing;
    }

    public String getEisvoorzorgsmaatregel() {
        return eisvoorzorgsmaatregel;
    }

    public void setEisvoorzorgsmaatregel(String eisvoorzorgsmaatregel) {
        this.eisvoorzorgsmaatregel = eisvoorzorgsmaatregel;
    }

    public Double getGeonauwkeurigheidxy() {
        return geonauwkeurigheidxy;
    }

    public void setGeonauwkeurigheidxy(Double geonauwkeurigheidxy) {
        this.geonauwkeurigheidxy = geonauwkeurigheidxy;
    }

    public String getMateriaal_leiding() {
        return materiaal_leiding;
    }

    public void setMateriaal_leiding(String materiaal_leiding) {
        this.materiaal_leiding = materiaal_leiding;
    }

    public String getProduct_leiding() {
        return product_leiding;
    }

    public void setProduct_leiding(String product_leiding) {
        this.product_leiding = product_leiding;
    }

    public String getToelichting_imkl() {
        return toelichting_imkl;
    }

    public void setToelichting_imkl(String toelichting_imkl) {
        this.toelichting_imkl = toelichting_imkl;
    }

    public String getVerhoogd_risico() {
        return verhoogd_risico;
    }

    public void setVerhoogd_risico(String verhoogd_risico) {
        this.verhoogd_risico = verhoogd_risico;
    }

    public Double getAantal_buizen() {
        return aantal_buizen;
    }

    public void setAantal_buizen(Double aantal_buizen) {
        this.aantal_buizen = aantal_buizen;
    }

    public Double getDiameter() {
        return diameter;
    }

    public void setDiameter(Double diameter) {
        this.diameter = diameter;
    }

    public Date getBegin_tijd() {
        return begin_tijd;
    }

    public void setBegin_tijd(Date begin_tijd) {
        this.begin_tijd = begin_tijd;
    }

    public Date getEind_tijd() {
        return eind_tijd;
    }

    public void setEind_tijd(Date eind_tijd) {
        this.eind_tijd = eind_tijd;
    }

    public String getToelichting() {
        return toelichting;
    }

    public void setToelichting(String toelichting) {
        this.toelichting = toelichting;
    }

    public String getAfbeelding() {
        return afbeelding;
    }

    public void setAfbeelding(String afbeelding) {
        this.afbeelding = afbeelding;
    }

    public String getBeheerder() {
        return beheerder;
    }

    public void setBeheerder(String beheerder) {
        this.beheerder = beheerder;
    }

    public String getHoofdcategorie() {
        return hoofdcategorie;
    }

    public void setHoofdcategorie(String hoofdcategorie) {
        this.hoofdcategorie = hoofdcategorie;
    }

    public String getX62_std_hoofdcategorie() {
        return x62_std_hoofdcategorie;
    }

    public void setX62_std_hoofdcategorie(String x62_std_hoofdcategorie) {
        this.x62_std_hoofdcategorie = x62_std_hoofdcategorie;
    }

    public String getCategorie() {
        return categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getX62_std_categorie() {
        return x62_std_categorie;
    }

    public void setX62_std_categorie(String x62_std_categorie) {
        this.x62_std_categorie = x62_std_categorie;
    }

    public String getSubcategorie() {
        return subcategorie;
    }

    public void setSubcategorie(String subcategorie) {
        this.subcategorie = subcategorie;
    }

    public String getX62_std_subcategorie() {
        return x62_std_subcategorie;
    }

    public void setX62_std_subcategorie(String x62_std_subcategorie) {
        this.x62_std_subcategorie = x62_std_subcategorie;
    }

    public String getPersleidingtype() {
        return persleidingtype;
    }

    public void setPersleidingtype(String persleidingtype) {
        this.persleidingtype = persleidingtype;
    }

    public String getStd_persleidingtype() {
        return std_persleidingtype;
    }

    public void setStd_persleidingtype(String std_persleidingtype) {
        this.std_persleidingtype = std_persleidingtype;
    }

    public Double getAanlegjaar() {
        return aanlegjaar;
    }

    public void setAanlegjaar(Double aanlegjaar) {
        this.aanlegjaar = aanlegjaar;
    }

    public Double getLengte() {
        return lengte;
    }

    public void setLengte(Double lengte) {
        this.lengte = lengte;
    }

    public String getGrondsoort() {
        return grondsoort;
    }

    public void setGrondsoort(String grondsoort) {
        this.grondsoort = grondsoort;
    }

    public String getStd_grondsoort() {
        return std_grondsoort;
    }

    public void setStd_grondsoort(String std_grondsoort) {
        this.std_grondsoort = std_grondsoort;
    }

    public String getBovenliggende_verharding() {
        return bovenliggende_verharding;
    }

    public void setBovenliggende_verharding(String bovenliggende_verharding) {
        this.bovenliggende_verharding = bovenliggende_verharding;
    }

    public Double getDiepte_begin() {
        return diepte_begin;
    }

    public void setDiepte_begin(Double diepte_begin) {
        this.diepte_begin = diepte_begin;
    }

    public Double getDiepte_max() {
        return diepte_max;
    }

    public void setDiepte_max(Double diepte_max) {
        this.diepte_max = diepte_max;
    }

    public Double getDiepte_eind() {
        return diepte_eind;
    }

    public void setDiepte_eind(Double diepte_eind) {
        this.diepte_eind = diepte_eind;
    }

    public String getWaterslagvoorziening() {
        return waterslagvoorziening;
    }

    public void setWaterslagvoorziening(String waterslagvoorziening) {
        this.waterslagvoorziening = waterslagvoorziening;
    }

    public Double getOntluchtingspunten() {
        return ontluchtingspunten;
    }

    public void setOntluchtingspunten(Double ontluchtingspunten) {
        this.ontluchtingspunten = ontluchtingspunten;
    }

    public String getMateriaal_rioolleiding() {
        return materiaal_rioolleiding;
    }

    public void setMateriaal_rioolleiding(String materiaal_rioolleiding) {
        this.materiaal_rioolleiding = materiaal_rioolleiding;
    }

    public String getStd_materiaal_rioolleiding() {
        return std_materiaal_rioolleiding;
    }

    public void setStd_materiaal_rioolleiding(String std_materiaal_rioolleiding) {
        this.std_materiaal_rioolleiding = std_materiaal_rioolleiding;
    }

    public String getStroomgebied() {
        return stroomgebied;
    }

    public void setStroomgebied(String stroomgebied) {
        this.stroomgebied = stroomgebied;
    }

    public String getBemalingsgebied() {
        return bemalingsgebied;
    }

    public void setBemalingsgebied(String bemalingsgebied) {
        this.bemalingsgebied = bemalingsgebied;
    }

    public String getStelseltype() {
        return stelseltype;
    }

    public void setStelseltype(String stelseltype) {
        this.stelseltype = stelseltype;
    }

    public String getStd_stelseltype() {
        return std_stelseltype;
    }

    public void setStd_stelseltype(String std_stelseltype) {
        this.std_stelseltype = std_stelseltype;
    }

    public String getBuistype() {
        return buistype;
    }

    public void setBuistype(String buistype) {
        this.buistype = buistype;
    }

    public String getStd_buistype() {
        return std_buistype;
    }

    public void setStd_buistype(String std_buistype) {
        this.std_buistype = std_buistype;
    }

    public String getWoonplaats() {
        return woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getWijk() {
        return wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getBuurt() {
        return buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOpenbare_ruimte() {
        return openbare_ruimte;
    }

    public void setOpenbare_ruimte(String openbare_ruimte) {
        this.openbare_ruimte = openbare_ruimte;
    }

    public Well getPompput() {
        return pompput;
    }

    public void setPompput(Well pompput) {
        this.pompput = pompput;
    }

    public Well getLozingsput() {
        return lozingsput;
    }

    public void setLozingsput(Well lozingsput) {
        this.lozingsput = lozingsput;
    }

    public String getType_leiding() {
        return type_leiding;
    }

    public void setType_leiding(String type_leiding) {
        this.type_leiding = type_leiding;
    }

    public String getDrukklasse() {
        return drukklasse;
    }

    public void setDrukklasse(String drukklasse) {
        this.drukklasse = drukklasse;
    }

    public String getFunderingstype() {
        return funderingstype;
    }

    public void setFunderingstype(String funderingstype) {
        this.funderingstype = funderingstype;
    }

    public Double getHoogte() {
        return hoogte;
    }

    public void setHoogte(Double hoogte) {
        this.hoogte = hoogte;
    }

    public Double getWandruwheid() {
        return wandruwheid;
    }

    public void setWandruwheid(Double wandruwheid) {
        this.wandruwheid = wandruwheid;
    }

    public Double getWandruwheid_bb() {
        return wandruwheid_bb;
    }

    public void setWandruwheid_bb(Double wandruwheid_bb) {
        this.wandruwheid_bb = wandruwheid_bb;
    }

    public Double getWandruwheid_bo() {
        return wandruwheid_bo;
    }

    public void setWandruwheid_bo(Double wandruwheid_bo) {
        this.wandruwheid_bo = wandruwheid_bo;
    }

    public String getLeverancier_fabrikant() {
        return leverancier_fabrikant;
    }

    public void setLeverancier_fabrikant(String leverancier_fabrikant) {
        this.leverancier_fabrikant = leverancier_fabrikant;
    }

    public String getMateriaal_gwsw() {
        return materiaal_gwsw;
    }

    public void setMateriaal_gwsw(String materiaal_gwsw) {
        this.materiaal_gwsw = materiaal_gwsw;
    }

    public String getVorm() {
        return vorm;
    }

    public void setVorm(String vorm) {
        this.vorm = vorm;
    }

    public String getToegankelijk() {
        return toegankelijk;
    }

    public void setToegankelijk(String toegankelijk) {
        this.toegankelijk = toegankelijk;
    }

    public String getVerbindingstype() {
        return verbindingstype;
    }

    public void setVerbindingstype(String verbindingstype) {
        this.verbindingstype = verbindingstype;
    }

    public Double getVervuilingsgraad() {
        return vervuilingsgraad;
    }

    public void setVervuilingsgraad(Double vervuilingsgraad) {
        this.vervuilingsgraad = vervuilingsgraad;
    }

    public Double getWanddikte() {
        return wanddikte;
    }

    public void setWanddikte(Double wanddikte) {
        this.wanddikte = wanddikte;
    }

    public String getWion_thema() {
        return wion_thema;
    }

    public void setWion_thema(String wion_thema) {
        this.wion_thema = wion_thema;
    }

    public String getRevisietekening() {
        return revisietekening;
    }

    public void setRevisietekening(String revisietekening) {
        this.revisietekening = revisietekening;
    }

    public String getMech_leidingtype_gwsw() {
        return mech_leidingtype_gwsw;
    }

    public void setMech_leidingtype_gwsw(String mech_leidingtype_gwsw) {
        this.mech_leidingtype_gwsw = mech_leidingtype_gwsw;
    }

    public String getStatus_functioneren() {
        return status_functioneren;
    }

    public void setStatus_functioneren(String status_functioneren) {
        this.status_functioneren = status_functioneren;
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public String getCons_onderdeel_id() {
        return cons_onderdeel_id;
    }

    public void setCons_onderdeel_id(String cons_onderdeel_id) {
        this.cons_onderdeel_id = cons_onderdeel_id;
    }

    public String getSw_gebied_id() {
        return sw_gebied_id;
    }

    public void setSw_gebied_id(String sw_gebied_id) {
        this.sw_gebied_id = sw_gebied_id;
    }

    public String getStelsel_id() {
        return stelsel_id;
    }

    public void setStelsel_id(String stelsel_id) {
        this.stelsel_id = stelsel_id;
    }

    public String getMech_leiding_id() {
        return mech_leiding_id;
    }

    public void setMech_leiding_id(String mech_leiding_id) {
        this.mech_leiding_id = mech_leiding_id;
    }

    public Double getBreedte() {
        return breedte;
    }

    public void setBreedte(Double breedte) {
        this.breedte = breedte;
    }
}
