/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.List;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.ArtificialWorkPartRepository;
import nl.b3p.formendpoint.resource.ArtificialWorkPart;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormArtificialWorkPartController
implements FormController<ArtificialWorkPart> {
    @Autowired
    ArtificialWorkPartRepository repo;

    public Class getMaintainingClass() {
        return ArtificialWorkPart.class;
    }

    @GetMapping(value={"/kunstwerkdeel/{objectGuid}"})
    public ArtificialWorkPart get(@PathVariable String objectGuid) {
        return (ArtificialWorkPart)this.repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    public Page<ArtificialWorkPart> getAllPaged(@ParameterObject Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    public List<ArtificialWorkPart> getAll() {
        return this.repo.findAll();
    }

    public ArtificialWorkPart save(@RequestBody ArtificialWorkPart feature, String parentId) {
        return (ArtificialWorkPart)this.repo.save((Object)feature);
    }

    public ArtificialWorkPart update(@PathVariable String objectGuid, @RequestBody ArtificialWorkPart feature) {
        ArtificialWorkPart orig = (ArtificialWorkPart)this.repo.findByObjectGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)feature, (Object)orig, (String[])new String[]{"planningen", "inspecties"});
        ArtificialWorkPart nieuw = (ArtificialWorkPart)this.repo.save((Object)orig);
        return nieuw;
    }

    public void delete(String objectGuid) {
        this.repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value={"/kunstwerkdeel/{x}/{y}/{scale}"})
    public List<ArtificialWorkPart> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        return this.repo.findWithinPoint(p.buffer(scale));
    }
}

