/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.RoadinspectionRepository;
import nl.b3p.formendpoint.repository.RoadsectionRepository;
import nl.b3p.formendpoint.resource.RoadInspection;
import nl.b3p.formendpoint.resource.Roadsection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"weginspectie"})
public class FormRoadInspectionController
implements FormController<RoadInspection> {
    @Autowired
    RoadinspectionRepository repo;
    @Autowired
    RoadsectionRepository wvRepo;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/{objectGuid}"})
    public RoadInspection get(@PathVariable String objectGuid) {
        return (RoadInspection)this.repo.findByDataGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
    }

    public List<RoadInspection> onPoint(double x, double y, double scale) {
        return new ArrayList<RoadInspection>();
    }

    @GetMapping
    public Page<RoadInspection> getAllPaged(Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    @GetMapping(value={"/unpaged"})
    public List<RoadInspection> getAll() {
        return this.repo.findAll();
    }

    @PostMapping
    public RoadInspection save(@RequestBody RoadInspection wv, String parentId) {
        Roadsection parent = (Roadsection)this.wvRepo.findByObjectGuid(parentId).orElseThrow(() -> new IllegalArgumentException("Parent niet gevonden"));
        wv.setWegvakonderdeelId(parent.getObjectGuid());
        return (RoadInspection)this.repo.save((Object)wv);
    }

    @PutMapping(value={"/{objectGuid}"})
    public RoadInspection update(@PathVariable String objectGuid, @RequestBody RoadInspection wv) {
        RoadInspection orig = (RoadInspection)this.repo.findByDataGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)wv, (Object)orig);
        RoadInspection nieuw = (RoadInspection)this.repo.save((Object)orig);
        return nieuw;
    }

    @DeleteMapping(value={"/{objectGuid}"})
    public void delete(@PathVariable String objectGuid) {
        this.repo.deleteByDataGuid(objectGuid);
    }

    public Class getMaintainingClass() {
        return RoadInspection.class;
    }
}

