package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.RoadinspectionRepository;
import nl.b3p.formendpoint.repository.RoadsectionRepository;
import nl.b3p.formendpoint.resource.RoadInspection;
import nl.b3p.formendpoint.resource.Roadsection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("weginspectie")
public class FormRoadInspectionController implements FormController<RoadInspection>{

    @Autowired
    RoadinspectionRepository repo;

    @Autowired
    RoadsectionRepository wvRepo;

    Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping("/{objectGuid}")
    public RoadInspection get(@PathVariable String objectGuid) {
        return repo.findByDataGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));
    }

    @Override
    public List<RoadInspection> onPoint(double x, double y, double scale) {
        return new ArrayList<>();
    }

    @Override
    @GetMapping
    public Page<RoadInspection> getAllPaged(Pageable pageable) {
        return repo.findAll(pageable);
    }

    @GetMapping("/unpaged")
    public List<RoadInspection> getAll() {
        return repo.findAll();
    }

    @PostMapping
    public RoadInspection save(@RequestBody RoadInspection wv, String parentId){
        Roadsection parent = wvRepo.findByObjectGuid(parentId).orElseThrow( () -> new IllegalArgumentException("Parent niet gevonden"));;
        wv.setWegvakonderdeelId(parent.getObjectGuid());
        return repo.save(wv);
    }

    @PutMapping("/{objectGuid}")
    public RoadInspection update(@PathVariable  String objectGuid, @RequestBody RoadInspection wv){
        RoadInspection orig=  repo.findByDataGuid(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(wv, orig);
        RoadInspection nieuw = repo.save(orig);
        return nieuw;
    }

    @DeleteMapping("/{objectGuid}")
    public void delete(@PathVariable String objectGuid){
        repo.deleteByDataGuid(objectGuid);
    }

    @Override
    public Class getMaintainingClass() {
        return RoadInspection.class;
    }
}
