package nl.b3p.formendpoint.controller;

import nl.b3p.formendpoint.repository.IMBORTreeRepository;
import nl.b3p.formendpoint.resource.IMBORTree;
import nl.b3p.formendpoint.resource.TreeInspection;
import nl.b3p.formendpoint.resource.IMBORTree;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

@RestController
public class IMBORTreeController  implements FormController<IMBORTree>{


    @Autowired
    IMBORTreeRepository repo;

    @Override
    public Class getMaintainingClass() {
        return IMBORTree.class;
    }

    @GetMapping("/imborboom/{objectGuid}")
    public IMBORTree get(@PathVariable String objectGuid) {
        Optional<IMBORTree> maybe = repo.findByImborIdentificatie(objectGuid);
        IMBORTree IMBORTree = maybe.orElseThrow();

        return IMBORTree;
    }

    @Override
    public Page<IMBORTree> getAllPaged(@ParameterObject Pageable pageable) {
        return repo.findAll(pageable);
    }

    @Override
    public List<IMBORTree> getAll() {
        return repo.findAll();
    }

    @Override
    public IMBORTree save(@RequestBody IMBORTree feature, String parentId) {
        return repo.save(feature);
    }

    @Override
    public IMBORTree update(@PathVariable String objectGuid, @RequestBody IMBORTree feature) {
        IMBORTree orig=  repo.findByImborIdentificatie(objectGuid).orElseThrow( () -> new IllegalArgumentException("niet gevonden"));

        BeanUtils.copyProperties(feature, orig, "planningen", "inspecties");
        IMBORTree nieuw = repo.save(orig);
        return nieuw;
    }

    @Override
    public void delete(String objectGuid) {
        repo.deleteByImborIdentificatie(objectGuid);
    }

    @GetMapping(value = "/imborboom/{x}/{y}/{scale}")
    public List<IMBORTree> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2), 28992);
        Point p  = gf.createPoint(new Coordinate(x, y));
        return repo.findWithinPoint(p.buffer(scale));
    }

    
}
