package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.CultPlanting;
import nl.b3p.formendpoint.resource.Tree;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface CultPlantingRepository extends JpaRepository<CultPlanting, Long> {
    Optional<CultPlanting> findById(Long id);

    Optional<CultPlanting> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<CultPlanting> findWithinPoint(Geometry area);

}
