package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.Gbikwplanningnentot;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface Gbi_kw_planning_nen_totRepository extends JpaRepository<Gbikwplanningnentot, Long> {

    Optional<Gbikwplanningnentot> findById(Long id);

    Optional<Gbikwplanningnentot> findByObjectGuid(String object_guid);

    void deleteByObjectGuid(String object_guid);


    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<Gbikwplanningnentot> findWithinPoint(Geometry area);
}
