package nl.b3p.formendpoint.repository;

import nl.b3p.formendpoint.resource.Planter;
import nl.b3p.formendpoint.resource.Roadsection;
import org.locationtech.jts.geom.Geometry;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface PlanterRepository extends JpaRepository<Planter, Long> {

    Optional<Planter> findByObjectGuid(String object_guid);

    Optional<Planter> findById(Long id);

    void deleteByObjectGuid(String object_guid);

    @Query(value
            = "Select t from #{#entityName} t"
            + " where intersects(t.geometrie, :area) = true"
    )
    List<Planter> findWithinPoint(Geometry area);

}
