package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;

@Entity(name = "gb_kunstwerk_planning")
@Schema(
        name = "KunstwerkPlanning",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ArtificialWorkPlanning implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    private String data_guid;
    private String maatregel_kw;
    private String maatregeltype;
    private Integer jaarvanuitvoering;
    private Integer hoeveelheid;
    private Integer kosten;
    private String gepland_uitgevoerd;
    private String planstatus;
    private Integer frequentie;
    private String kunstwerk_id;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getData_guid() {
        return data_guid;
    }

    public void setData_guid(String data_guid) {
        this.data_guid = data_guid;
    }

    public String getMaatregel_kw() {
        return maatregel_kw;
    }

    public void setMaatregel_kw(String maatregel_kw) {
        this.maatregel_kw = maatregel_kw;
    }

    public String getMaatregeltype() {
        return maatregeltype;
    }

    public void setMaatregeltype(String maatregeltype) {
        this.maatregeltype = maatregeltype;
    }

    public Integer getJaarvanuitvoering() {
        return jaarvanuitvoering;
    }

    public void setJaarvanuitvoering(Integer jaarvanuitvoering) {
        this.jaarvanuitvoering = jaarvanuitvoering;
    }

    public Integer getHoeveelheid() {
        return hoeveelheid;
    }

    public void setHoeveelheid(Integer hoeveelheid) {
        this.hoeveelheid = hoeveelheid;
    }

    public Integer getKosten() {
        return kosten;
    }

    public void setKosten(Integer kosten) {
        this.kosten = kosten;
    }

    public String getGepland_uitgevoerd() {
        return gepland_uitgevoerd;
    }

    public void setGepland_uitgevoerd(String gepland_uitgevoerd) {
        this.gepland_uitgevoerd = gepland_uitgevoerd;
    }

    public String getPlanstatus() {
        return planstatus;
    }

    public void setPlanstatus(String planstatus) {
        this.planstatus = planstatus;
    }

    public Integer getFrequentie() {
        return frequentie;
    }

    public void setFrequentie(Integer frequentie) {
        this.frequentie = frequentie;
    }

    public String getKunstwerk_id() {
        return kunstwerk_id;
    }

    public void setKunstwerk_id(String kunstwerk_id) {
        this.kunstwerk_id = kunstwerk_id;
    }

    @Override
    public String getObjectGuid() {
        return data_guid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.data_guid = objectGuid;

    }
}
