package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.hibernate.annotations.ColumnTransformer;
import org.locationtech.jts.geom.Geometry;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity(name = "gb_haag")
@Schema(
        name = "Haag",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Hedge implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Schema(implementation = org.geojson.Geometry.class)
    @Basic(optional = false)
    @ColumnTransformer(
            read = "st_curvetoline(geometrie)"
    )
    private Geometry geometrie;

    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(referencedColumnName = "objectGuid", name = "haag_id")
    private List<HedgePlanning> planningen = new ArrayList<>();

    @Override
    public List<Feature> getChildren() {
        List<Feature> childs = new ArrayList<>();
        if (planningen != null) {
            planningen.forEach(hedgePlanning -> childs.add(hedgePlanning));
        }
        return childs;
    }

    @Schema(name = "object_guid")
    private String objectGuid;
    private String imgeo_id;
    private String bbv;
    private String domein;
    private String std_domein;
    private String beheercluster;
    private String std_beheercluster;
    private String structuurelement;
    private String std_structuurelement;
    private String beheerder_vakgeb;
    private String std_beheerder_vakgeb;
    private String bestek_nr;
    private String x62_cluster_aard;
    private String rayon;
    private String x62_std_rayon;
    private String status;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date object_eind_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_begin;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date reg_eind;
    private String in_onderzoek;
    private Double relatieve_hoogteligging;
    private String bronhouder;
    private String type_vegetatieobj_plus;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date begin_tijd;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date eind_tijd;
    private String toelichting;
    private String afbeelding;
    private String beheerder;
    private String hoofdcategorie;
    private String x62_std_hoofdcategorie;
    private String categorie;
    private String x62_std_categorie;
    private String subcategorie;
    private String x62_std_subcategorie;
    private String haagtype;
    private String std_haagtype;
    private String grondslag;
    private String std_grondslag;
    private String gebruiksdruk;
    private String std_gebruiksdruk;
    private Double oppervlakte;
    private Double lengte;
    private Double hoogte;
    private Double aanlegjaar;
    private String ploegindeling;
    private Double harde_rand;
    private Double zachte_rand;
    private Double knipopp;
    private Double hknipopp;
    private String woonplaats;
    private String wijk;
    private String buurt;
    private String openbare_ruimte;
    private String groenobject_id;
    private Double aantal_knipbeurten;
    private String aantal_zijden;
    private String hoogte_haag;
    private Double breedte;
    private String gemeente;

    public Geometry getGeometrie() {
        return geometrie;
    }

    public void setGeometrie(Geometry geometrie) {
        this.geometrie = geometrie;
    }

    public String getObjectGuid() {
        return objectGuid;
    }

    public void setObjectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
    }

    public String getImgeo_id() {
        return imgeo_id;
    }

    public void setImgeo_id(String imgeo_id) {
        this.imgeo_id = imgeo_id;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getBbv() {
        return bbv;
    }

    public void setBbv(String bbv) {
        this.bbv = bbv;
    }

    public String getDomein() {
        return domein;
    }

    public void setDomein(String domein) {
        this.domein = domein;
    }

    public String getStd_domein() {
        return std_domein;
    }

    public void setStd_domein(String std_domein) {
        this.std_domein = std_domein;
    }

    public String getBeheercluster() {
        return beheercluster;
    }

    public void setBeheercluster(String beheercluster) {
        this.beheercluster = beheercluster;
    }

    public String getStd_beheercluster() {
        return std_beheercluster;
    }

    public void setStd_beheercluster(String std_beheercluster) {
        this.std_beheercluster = std_beheercluster;
    }

    public String getStructuurelement() {
        return structuurelement;
    }

    public void setStructuurelement(String structuurelement) {
        this.structuurelement = structuurelement;
    }

    public String getStd_structuurelement() {
        return std_structuurelement;
    }

    public void setStd_structuurelement(String std_structuurelement) {
        this.std_structuurelement = std_structuurelement;
    }

    public String getBeheerder_vakgeb() {
        return beheerder_vakgeb;
    }

    public void setBeheerder_vakgeb(String beheerder_vakgeb) {
        this.beheerder_vakgeb = beheerder_vakgeb;
    }

    public String getStd_beheerder_vakgeb() {
        return std_beheerder_vakgeb;
    }

    public void setStd_beheerder_vakgeb(String std_beheerder_vakgeb) {
        this.std_beheerder_vakgeb = std_beheerder_vakgeb;
    }

    public String getBestek_nr() {
        return bestek_nr;
    }

    public void setBestek_nr(String bestek_nr) {
        this.bestek_nr = bestek_nr;
    }

    public String getX62_cluster_aard() {
        return x62_cluster_aard;
    }

    public void setX62_cluster_aard(String x62_cluster_aard) {
        this.x62_cluster_aard = x62_cluster_aard;
    }

    public String getRayon() {
        return rayon;
    }

    public void setRayon(String rayon) {
        this.rayon = rayon;
    }

    public String getX62_std_rayon() {
        return x62_std_rayon;
    }

    public void setX62_std_rayon(String x62_std_rayon) {
        this.x62_std_rayon = x62_std_rayon;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getObject_begin_tijd() {
        return object_begin_tijd;
    }

    public void setObject_begin_tijd(Date object_begin_tijd) {
        this.object_begin_tijd = object_begin_tijd;
    }

    public Date getObject_eind_tijd() {
        return object_eind_tijd;
    }

    public void setObject_eind_tijd(Date object_eind_tijd) {
        this.object_eind_tijd = object_eind_tijd;
    }

    public Date getReg_begin() {
        return reg_begin;
    }

    public void setReg_begin(Date reg_begin) {
        this.reg_begin = reg_begin;
    }

    public Date getReg_eind() {
        return reg_eind;
    }

    public void setReg_eind(Date reg_eind) {
        this.reg_eind = reg_eind;
    }

    public String getIn_onderzoek() {
        return in_onderzoek;
    }

    public void setIn_onderzoek(String in_onderzoek) {
        this.in_onderzoek = in_onderzoek;
    }

    public Double getRelatieve_hoogteligging() {
        return relatieve_hoogteligging;
    }

    public void setRelatieve_hoogteligging(Double relatieve_hoogteligging) {
        this.relatieve_hoogteligging = relatieve_hoogteligging;
    }

    public String getBronhouder() {
        return bronhouder;
    }

    public void setBronhouder(String bronhouder) {
        this.bronhouder = bronhouder;
    }

    public String getType_vegetatieobj_plus() {
        return type_vegetatieobj_plus;
    }

    public void setType_vegetatieobj_plus(String type_vegetatieobj_plus) {
        this.type_vegetatieobj_plus = type_vegetatieobj_plus;
    }

    public Date getBegin_tijd() {
        return begin_tijd;
    }

    public void setBegin_tijd(Date begin_tijd) {
        this.begin_tijd = begin_tijd;
    }

    public Date getEind_tijd() {
        return eind_tijd;
    }

    public void setEind_tijd(Date eind_tijd) {
        this.eind_tijd = eind_tijd;
    }

    public String getToelichting() {
        return toelichting;
    }

    public void setToelichting(String toelichting) {
        this.toelichting = toelichting;
    }

    public String getAfbeelding() {
        return afbeelding;
    }

    public void setAfbeelding(String afbeelding) {
        this.afbeelding = afbeelding;
    }

    public String getBeheerder() {
        return beheerder;
    }

    public void setBeheerder(String beheerder) {
        this.beheerder = beheerder;
    }

    public String getHoofdcategorie() {
        return hoofdcategorie;
    }

    public void setHoofdcategorie(String hoofdcategorie) {
        this.hoofdcategorie = hoofdcategorie;
    }

    public String getX62_std_hoofdcategorie() {
        return x62_std_hoofdcategorie;
    }

    public void setX62_std_hoofdcategorie(String x62_std_hoofdcategorie) {
        this.x62_std_hoofdcategorie = x62_std_hoofdcategorie;
    }

    public String getCategorie() {
        return categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getX62_std_categorie() {
        return x62_std_categorie;
    }

    public void setX62_std_categorie(String x62_std_categorie) {
        this.x62_std_categorie = x62_std_categorie;
    }

    public String getSubcategorie() {
        return subcategorie;
    }

    public void setSubcategorie(String subcategorie) {
        this.subcategorie = subcategorie;
    }

    public String getX62_std_subcategorie() {
        return x62_std_subcategorie;
    }

    public void setX62_std_subcategorie(String x62_std_subcategorie) {
        this.x62_std_subcategorie = x62_std_subcategorie;
    }

    public String getHaagtype() {
        return haagtype;
    }

    public void setHaagtype(String haagtype) {
        this.haagtype = haagtype;
    }

    public String getStd_haagtype() {
        return std_haagtype;
    }

    public void setStd_haagtype(String std_haagtype) {
        this.std_haagtype = std_haagtype;
    }

    public String getGrondslag() {
        return grondslag;
    }

    public void setGrondslag(String grondslag) {
        this.grondslag = grondslag;
    }

    public String getStd_grondslag() {
        return std_grondslag;
    }

    public void setStd_grondslag(String std_grondslag) {
        this.std_grondslag = std_grondslag;
    }

    public String getGebruiksdruk() {
        return gebruiksdruk;
    }

    public void setGebruiksdruk(String gebruiksdruk) {
        this.gebruiksdruk = gebruiksdruk;
    }

    public String getStd_gebruiksdruk() {
        return std_gebruiksdruk;
    }

    public void setStd_gebruiksdruk(String std_gebruiksdruk) {
        this.std_gebruiksdruk = std_gebruiksdruk;
    }

    public Double getOppervlakte() {
        return oppervlakte;
    }

    public void setOppervlakte(Double oppervlakte) {
        this.oppervlakte = oppervlakte;
    }

    public Double getLengte() {
        return lengte;
    }

    public void setLengte(Double lengte) {
        this.lengte = lengte;
    }

    public Double getHoogte() {
        return hoogte;
    }

    public void setHoogte(Double hoogte) {
        this.hoogte = hoogte;
    }

    public Double getAanlegjaar() {
        return aanlegjaar;
    }

    public void setAanlegjaar(Double aanlegjaar) {
        this.aanlegjaar = aanlegjaar;
    }

    public String getPloegindeling() {
        return ploegindeling;
    }

    public void setPloegindeling(String ploegindeling) {
        this.ploegindeling = ploegindeling;
    }

    public Double getHarde_rand() {
        return harde_rand;
    }

    public void setHarde_rand(Double harde_rand) {
        this.harde_rand = harde_rand;
    }

    public Double getZachte_rand() {
        return zachte_rand;
    }

    public void setZachte_rand(Double zachte_rand) {
        this.zachte_rand = zachte_rand;
    }

    public Double getKnipopp() {
        return knipopp;
    }

    public void setKnipopp(Double knipopp) {
        this.knipopp = knipopp;
    }

    public Double getHknipopp() {
        return hknipopp;
    }

    public void setHknipopp(Double hknipopp) {
        this.hknipopp = hknipopp;
    }

    public String getWoonplaats() {
        return woonplaats;
    }

    public void setWoonplaats(String woonplaats) {
        this.woonplaats = woonplaats;
    }

    public String getWijk() {
        return wijk;
    }

    public void setWijk(String wijk) {
        this.wijk = wijk;
    }

    public String getBuurt() {
        return buurt;
    }

    public void setBuurt(String buurt) {
        this.buurt = buurt;
    }

    public String getOpenbare_ruimte() {
        return openbare_ruimte;
    }

    public void setOpenbare_ruimte(String openbare_ruimte) {
        this.openbare_ruimte = openbare_ruimte;
    }

    public String getGroenobject_id() {
        return groenobject_id;
    }

    public void setGroenobject_id(String groenobject_id) {
        this.groenobject_id = groenobject_id;
    }

    public Double getAantal_knipbeurten() {
        return aantal_knipbeurten;
    }

    public void setAantal_knipbeurten(Double aantal_knipbeurten) {
        this.aantal_knipbeurten = aantal_knipbeurten;
    }

    public String getAantal_zijden() {
        return aantal_zijden;
    }

    public void setAantal_zijden(String aantal_zijden) {
        this.aantal_zijden = aantal_zijden;
    }

    public String getHoogte_haag() {
        return hoogte_haag;
    }

    public void setHoogte_haag(String hoogte_haag) {
        this.hoogte_haag = hoogte_haag;
    }

    public Double getBreedte() {
        return breedte;
    }

    public void setBreedte(Double breedte) {
        this.breedte = breedte;
    }

    public String getGemeente() {
        return gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }
}
