package nl.b3p.formendpoint.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

@Entity(name = "gb_rioolputinspectie")
@Schema(
        name = "RioolputInspectie",
        allOf = Feature.class
)
@JsonIgnoreProperties(ignoreUnknown = true)
public class WellInspection implements Feature, Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    @Schema(name = "data_guid")
    private String dataGuid;
    @JsonFormat(pattern = "dd-MM-yyyy HH:mm:ss")
    private Date inspectiedatum;
    private Double dab_scheur;
    private Double dac_breuk_instorting;
    private Double dad_defect_metselwerk;
    private Double daf_schade_oppervlak;
    private Double dba_wortels;
    private Double dbd_binnendringen_grond;
    private Double dbf_infiltratie;
    private String rioolput_id;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDataGuid() {
        return dataGuid;
    }

    public void setDataGuid(String dataGuid) {
        this.dataGuid = dataGuid;
    }

    public Date getInspectiedatum() {
        return inspectiedatum;
    }

    public void setInspectiedatum(Date inspectiedatum) {
        this.inspectiedatum = inspectiedatum;
    }

    public Double getDab_scheur() {
        return dab_scheur;
    }

    public void setDab_scheur(Double dab_scheur) {
        this.dab_scheur = dab_scheur;
    }

    public Double getDac_breuk_instorting() {
        return dac_breuk_instorting;
    }

    public void setDac_breuk_instorting(Double dac_breuk_instorting) {
        this.dac_breuk_instorting = dac_breuk_instorting;
    }

    public Double getDad_defect_metselwerk() {
        return dad_defect_metselwerk;
    }

    public void setDad_defect_metselwerk(Double dad_defect_metselwerk) {
        this.dad_defect_metselwerk = dad_defect_metselwerk;
    }

    public Double getDaf_schade_oppervlak() {
        return daf_schade_oppervlak;
    }

    public void setDaf_schade_oppervlak(Double daf_schade_oppervlak) {
        this.daf_schade_oppervlak = daf_schade_oppervlak;
    }

    public Double getDba_wortels() {
        return dba_wortels;
    }

    public void setDba_wortels(Double dba_wortels) {
        this.dba_wortels = dba_wortels;
    }

    public Double getDbd_binnendringen_grond() {
        return dbd_binnendringen_grond;
    }

    public void setDbd_binnendringen_grond(Double dbd_binnendringen_grond) {
        this.dbd_binnendringen_grond = dbd_binnendringen_grond;
    }

    public Double getDbf_infiltratie() {
        return dbf_infiltratie;
    }

    public void setDbf_infiltratie(Double dbf_infiltratie) {
        this.dbf_infiltratie = dbf_infiltratie;
    }

    public String getRioolput_id() {
        return rioolput_id;
    }

    public void setRioolput_id(String rioolput_id) {
        this.rioolput_id = rioolput_id;
    }

    @Override
    public String getObjectGuid() {
        return dataGuid;
    }

    @Override
    public void setObjectGuid(String objectGuid) {
        this.dataGuid = objectGuid;
    }
}
