/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.List;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.MechanicalDuctRepository;
import nl.b3p.formendpoint.resource.MechanicalDuct;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormMechanicalDuctController
implements FormController<MechanicalDuct> {
    @Autowired
    MechanicalDuctRepository repo;

    public Class getMaintainingClass() {
        return MechanicalDuct.class;
    }

    @GetMapping(value={"/mechanischeleiding/{objectGuid}"})
    public MechanicalDuct get(@PathVariable String objectGuid) {
        return (MechanicalDuct)this.repo.findByObjectGuid(objectGuid).orElseThrow();
    }

    public Page<MechanicalDuct> getAllPaged(@ParameterObject Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    public List<MechanicalDuct> getAll() {
        return this.repo.findAll();
    }

    public MechanicalDuct save(@RequestBody MechanicalDuct feature, String parentId) {
        return (MechanicalDuct)this.repo.save((Object)feature);
    }

    public MechanicalDuct update(@PathVariable String objectGuid, @RequestBody MechanicalDuct feature) {
        MechanicalDuct orig = (MechanicalDuct)this.repo.findByObjectGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)feature, (Object)orig, (String[])new String[]{"planningen", "inspecties"});
        MechanicalDuct nieuw = (MechanicalDuct)this.repo.save((Object)orig);
        return nieuw;
    }

    public void delete(String objectGuid) {
        this.repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value={"/mechanischeleiding/{x}/{y}/{scale}"})
    public List<MechanicalDuct> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        return this.repo.findWithinPoint(p.buffer(scale));
    }
}

