/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.TreeRepository;
import nl.b3p.formendpoint.repository.TreeplanningRepository;
import nl.b3p.formendpoint.resource.Tree;
import nl.b3p.formendpoint.resource.TreePlanning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"boomplanning"})
public class FormTreePlanningController
implements FormController<TreePlanning> {
    @Autowired
    TreeplanningRepository repo;
    @Autowired
    TreeRepository treeRepo;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping(value={"/{objectGuid}"})
    public TreePlanning get(@PathVariable String objectGuid) {
        return (TreePlanning)this.repo.findByDataGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
    }

    public List<TreePlanning> onPoint(double x, double y, double scale) {
        return new ArrayList<TreePlanning>();
    }

    @GetMapping
    public Page<TreePlanning> getAllPaged(Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    @GetMapping(value={"/unpaged"})
    public List<TreePlanning> getAll() {
        return this.repo.findAll();
    }

    @PostMapping
    public TreePlanning save(@RequestBody TreePlanning wv, String parentId) {
        Tree parent = (Tree)this.treeRepo.findByObjectGuid(parentId).orElseThrow(() -> new IllegalArgumentException("Parent niet gevonden"));
        wv.setBoom_id(parent.getObjectGuid());
        return (TreePlanning)this.repo.save((Object)wv);
    }

    @PutMapping(value={"/{objectGuid}"})
    public TreePlanning update(@PathVariable String objectGuid, @RequestBody TreePlanning wv) {
        TreePlanning orig = (TreePlanning)this.repo.findByDataGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)wv, (Object)orig);
        TreePlanning nieuw = (TreePlanning)this.repo.save((Object)orig);
        return nieuw;
    }

    @DeleteMapping(value={"/{objectGuid}"})
    public void delete(@PathVariable String objectGuid) {
        this.repo.deleteByDataGuid(objectGuid);
    }

    public Class getMaintainingClass() {
        return TreePlanning.class;
    }
}

