/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.List;
import java.util.Optional;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.WellRepository;
import nl.b3p.formendpoint.resource.Well;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormWellController
implements FormController<Well> {
    @Autowired
    WellRepository repo;

    public Class getMaintainingClass() {
        return Well.class;
    }

    @GetMapping(value={"/rioolput/{objectGuid}"})
    public Well get(@PathVariable String objectGuid) {
        Optional maybe = this.repo.findByObjectGuid(objectGuid);
        Well well = (Well)maybe.orElseThrow();
        return well;
    }

    public Page<Well> getAllPaged(@ParameterObject Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    public List<Well> getAll() {
        return this.repo.findAll();
    }

    public Well save(@RequestBody Well feature, String parentId) {
        return (Well)this.repo.save((Object)feature);
    }

    public Well update(@PathVariable String objectGuid, @RequestBody Well feature) {
        Well orig = (Well)this.repo.findByObjectGuid(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)feature, (Object)orig, (String[])new String[]{"planningen", "inspecties"});
        Well nieuw = (Well)this.repo.save((Object)orig);
        return nieuw;
    }

    public void delete(String objectGuid) {
        this.repo.deleteByObjectGuid(objectGuid);
    }

    @GetMapping(value={"/rioolput/{x}/{y}/{scale}"})
    public List<Well> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        return this.repo.findWithinPoint(p.buffer(scale));
    }
}

