/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.formendpoint.controller;

import java.util.List;
import java.util.Optional;
import nl.b3p.formendpoint.controller.FormController;
import nl.b3p.formendpoint.repository.IMBORGreenObjectRepository;
import nl.b3p.formendpoint.resource.IMBORGreenObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IMBORGreenObjectController
implements FormController<IMBORGreenObject> {
    @Autowired
    IMBORGreenObjectRepository repo;

    public Class getMaintainingClass() {
        return IMBORGreenObject.class;
    }

    @GetMapping(value={"/imborgroenobject/{objectGuid}"})
    public IMBORGreenObject get(@PathVariable String objectGuid) {
        Optional maybe = this.repo.findByImborIdentificatie(objectGuid);
        IMBORGreenObject IMBORGreenObject2 = (IMBORGreenObject)maybe.orElseThrow();
        return IMBORGreenObject2;
    }

    public Page<IMBORGreenObject> getAllPaged(@ParameterObject Pageable pageable) {
        return this.repo.findAll(pageable);
    }

    public List<IMBORGreenObject> getAll() {
        return this.repo.findAll();
    }

    public IMBORGreenObject save(@RequestBody IMBORGreenObject feature, String parentId) {
        return (IMBORGreenObject)this.repo.save((Object)feature);
    }

    public IMBORGreenObject update(@PathVariable String objectGuid, @RequestBody IMBORGreenObject feature) {
        IMBORGreenObject orig = (IMBORGreenObject)this.repo.findByImborIdentificatie(objectGuid).orElseThrow(() -> new IllegalArgumentException("niet gevonden"));
        BeanUtils.copyProperties((Object)feature, (Object)orig, (String[])new String[]{"planningen", "inspecties"});
        IMBORGreenObject nieuw = (IMBORGreenObject)this.repo.save((Object)orig);
        return nieuw;
    }

    public void delete(String objectGuid) {
        this.repo.deleteByImborIdentificatie(objectGuid);
    }

    @GetMapping(value={"/imborgroenobject/{x}/{y}/{scale}"})
    public List<IMBORGreenObject> onPoint(@PathVariable double x, @PathVariable double y, @PathVariable double scale) {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(2.0), 28992);
        Point p = gf.createPoint(new Coordinate(x, y));
        return this.repo.findWithinPoint(p.buffer(scale));
    }
}

